% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkChoice.R
\name{checkChoice}
\alias{assertChoice}
\alias{assert_choice}
\alias{checkChoice}
\alias{check_choice}
\alias{expect_choice}
\alias{testChoice}
\alias{test_choice}
\title{Check if an object is an element of a given set}
\usage{
checkChoice(x, choices)

check_choice(x, choices)

assertChoice(x, choices, .var.name = vname(x), add = NULL)

assert_choice(x, choices, .var.name = vname(x), add = NULL)

testChoice(x, choices)

test_choice(x, choices)

expect_choice(x, choices, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{choices}{[\code{atomic}]\cr
Set of possible values.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertChoice}/\code{assert_choice} return 
 \code{x} invisibly, whereas
 \code{checkChoice}/\code{check_choice} and 
 \code{testChoice}/\code{test_choice} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertChoice}/\code{assert_choice}
 throws an error message, 
 \code{testChoice}/\code{test_choice}
 returns \code{FALSE},
 and \code{checkChoice} returns a string with the error message.
 The function \code{expect_choice} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an object is an element of a given set
}
\note{
The object \code{x} must be of the same type as the set w.r.t. \code{\link[base]{typeof}}.
Integers and doubles are both treated as numeric.
}
\examples{
testChoice("x", letters)

# x is converted before the comparison if necessary
# note that this is subject to change in a future version
testChoice(factor("a"), "a")
testChoice(1, "1")
testChoice(1, as.integer(1))
}
\seealso{
Other set: \code{\link{checkSetEqual}},
  \code{\link{checkSubset}}
}

