% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkString.R
\name{checkString}
\alias{checkString}
\alias{check_string}
\alias{assertString}
\alias{assert_string}
\alias{testString}
\alias{test_string}
\alias{expect_string}
\title{Check if an argument is a string}
\usage{
checkString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE)

check_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE)

assertString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

assert_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

testString(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE)

test_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE)

expect_string(x, na.ok = FALSE, min.chars = NULL, pattern = NULL,
  fixed = NULL, ignore.case = FALSE, null.ok = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{min.chars}{[\code{integer(1)}]\cr
Minimum number of characters for each element of \code{x}.}

\item{pattern}{[\code{character(1L)}]\cr
Regular expression as used in \code{\link[base]{grepl}}.
All non-missing elements of \code{x} must comply to this pattern.}

\item{fixed}{[\code{character(1)}]\cr
Substring to detect in \code{x}. Will be used as \code{pattern} in \code{\link[base]{grepl}}
with option \code{fixed} set to \code{TRUE}.
All non-missing elements of \code{x} must contain this substring.}

\item{ignore.case}{[\code{logical(1)}]\cr
See \code{\link[base]{grepl}}. Default is \code{FALSE}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertString}/\code{assert_string} return 
 \code{x} invisibly, whereas
 \code{checkString}/\code{check_string} and 
 \code{testString}/\code{test_string} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertString}/\code{assert_string}
 throws an error message, 
 \code{testString}/\code{test_string}
 returns \code{FALSE},
 and \code{checkString} returns a string with the error message.
 The function \code{expect_string} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
A string is defined as a scalar character vector.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testString("a")
testString(letters)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkNumber}}, \code{\link{checkScalarNA}},
  \code{\link{checkScalar}}
}
\concept{scalars}
