% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mranUrl.R
\name{mranUrl}
\alias{mranUrl}
\title{Returns MRAN URL by querying options and defaults.}
\usage{
mranUrl()
}
\value{
Character string with URL
}
\description{
This function returns the current MRAN URL. The default for this is \code{http(s)://mran.microsoft.com/}, and is defined by setting the \code{checkpoint.mranUrl} option.
}
\section{Defining a new MRAN URL}{


To force \code{\link[=checkpoint]{checkpoint()}} to point to a differt URL, you can set the \code{checkpoint.mranUrl} option.

\code{options(checkpoint.mranUrl = "new_url")}
}

\examples{
mranUrl()  

\dontrun{
  
# Store the existing options
old_opts <- getOption("checkpoint.mranUrl")

# Set MRAN URL to different http address
options(checkpoint.mranUrl = "https://foobah")

# Set MRAN URL to local file address
options(checkpoint.mranUrl = "file:///~")

# Reset the original options
options(checkpoint.mranUrl = old_opts)
}
}
\seealso{
Other checkpoint functions: \code{\link{checkpointArchives}},
  \code{\link{checkpointRemove}}, \code{\link{checkpoint}},
  \code{\link{getAccessDate}},
  \code{\link{getValidSnapshots}},
  \code{\link{setSnapshot}}, \code{\link{unCheckpoint}}
}
