% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grepl.R
\name{check_grepl}
\alias{check_grepl}
\alias{check_regex}
\title{Check Matches Regular Expression}
\usage{
check_grepl(x, pattern = ".*", regex = pattern,
  x_name = substitute(x), error = TRUE)

check_regex(x, regex = ".*", x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{pattern}{A string of the regular expression.}

\item{regex}{A string of the regular expression (deprecated for pattern).}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether all the elements of an object match a regular expression.
}
\examples{
check_grepl("foo", "fo")
check_grepl("foo", "fo$", error = FALSE)
}
\seealso{
\code{\link{check_nchar}} and \code{\link{check_pattern}}
}
