% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_cheem_lists.r
\name{attr_df_treeshap}
\alias{attr_df_treeshap}
\title{Extract the full treeSHAP data.frame of a randomForest model}
\usage{
attr_df_treeshap(
  model,
  x,
  keep_heavy = FALSE,
  verbose = getOption("verbose"),
  noisy = getOption("verbose")
)
}
\arguments{
\item{model}{A tree based model supported by \code{treeshap}:
a model from \code{gbm}, \code{lightgbm}, \code{randomForest}, \code{ranger}, or  \code{xgboost}.}

\item{x}{The explanatory data (without response) to extract the local
attributions from.}

\item{keep_heavy}{Logical, if the heavy items "interactions",
"unified_model", and "observations" should be kept. Defaults to FALSE.}

\item{verbose}{Logical, if runtime should be printed. Defaults to TRUE.}

\item{noisy}{Logical, if a tone should be played on completion.
Defaults to TRUE.}
}
\value{
A data.frame of the local attributions for each observation.
}
\description{
A data.frame of each observations treeSHAP variable attributions of a
randomForest model.
A wrapper for \code{treeshap::randomForest.unify} and \code{treeshap::treeshap}.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

rf_fit  <- default_rf(X, Y)
## Long runtime for full datasets or complex models:
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                    model = rf_fit,
                    attr_df = shap_df)
global_view(this_ls)
}
\seealso{
Other cheem preprocessing: 
\code{\link{cheem_ls}()},
\code{\link{default_rf}()}
}
\concept{cheem preprocessing}
