% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.fragments.R
\name{filter.fragments}
\alias{filter.fragments}
\title{filter.fragments}
\usage{
filter.fragments(
  interaction.data,
  bait.filters = c(0, 1),
  target.filters = c(0, 1),
  verbose = FALSE
)
}
\arguments{
\item{interaction.data}{Data table containing interactions}

\item{bait.filters}{Vector of length two, where the first element corresponds to the lower-end filter and the second to the upper-end filter.
When global multiple testing correction is performed, altering the bait filtering settings may affect the number of significant results.}

\item{target.filters}{Vector of length two, giving lower and higher filter, respectively. 
Changing this filtering setting may affect multiple testing correction by altering the number of tests performed.}

\item{verbose}{Logical indicating whether to print progress reports.}
}
\value{
Data table containing fragments that passed all filters
}
\description{
Filter low and high-interacting restriction fragments based on the total number of trans counts
}
\examples{
# filter out lowest 10\% of baits
	filter.fragments(bre80, bait.filters = c(0.1, 1))

}
\author{
Erle Holgersen <Erle.Holgersen@icr.ac.uk>
}
