\name{get_weather}

\alias{get_weather}

\title{Download weather data from online database}

\description{This function retrieves either a list of nearby weather stations for a specified point location, or it downloads weather data for a specific weather station.}

\usage{
get_weather(location,time_interval,database="UCIPM",station_list=NULL,
stations_to_choose_from=25)
}

\arguments{
  \item{location}{   either a vector of geographic coordinates, or the 'chillRcode' of a weather station in the specified database. See details.}
  \item{time_interval}{   numeric vector with two elements, specifying the start and end date of the period of interest.}
  \item{database}{   the database to be accessed. Must be "GSOD", "CIMIS", "Wunderground" or "UCIPM". Since among these, "UCIPM" is the most comprehensive one for California, the initial area of interest, this is the default.}  
  \item{station_list}{    if the list of weather stations has already been downloaded, the list can be passed to the function through this argument. This can save a bit of time, since it can take a bit of time to download the list, which can have several MB.}
  \item{stations_to_choose_from}{    if the location is specified by geographic coordinates, this argument determines the number of nearby stations in the list that is returned.}
}
\details{   weather databases, from which chillR can download data:
NOAA NCDC Global Summary of the Day - "GSOD" (https://data.noaa.gov/dataset/global-surface-summary-of-the-day-gsod)

Weather Underground ("Wunderground") airport database - "Wunderground" (http://www.wunderground.com/)

California Irrigation Management Information System (CIMIS) - "CIMIS" (http://www.cimis.water.ca.gov/)

University of California Integrated Pest Management (UCIPM) - "UCIPM" (http://ipm.ucdavis.edu/WEATHER/)

several formats are possible for specifying the location vector, which can consist of either two or three coordinates (it can include elevation). Possible formats include c(1,2,3), c(1,2), c(x=1,y=2,z=3), c(lat=2,long=1,elev=3). If elements of the vector are not names, they are interpreted as c(Longitude, Latitude, Elevation).

The 'chillRCode' is generated by this function, when it is run with geographic coordinates as location inputs. In the list of nearby stations that is returned then, the chillRCode is provided and can then be used as input for running the function in 'downloading' mode. For downloading the data, use the same call as before but replace the location argument with the chillRCode.
}

\value{   The output depends on how the location is provided. If it is a coordinate vector, the function returns a list of station_to_choose_from weather stations that are close to the specified location. This list also contains information about how far away these stations are (in km), how much the elevation difference is (if elevation is specified; in m) and how much overlap there is between the data contained in the database and the time period specified by time_interval.
}

\references{
The chillR package:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat requirements of cherry trees - a statistical approach. International Journal of Biometeorology 57,679-689.
}

\author{Eike Luedeling}

\note{Many databases have data quality flags, which may sometimes indicate that data aren't reliable. These are not considered by this function!

see the documentation of the handler functions (e.g. handle_wunderground, handle_ucipm) for details.
}

\examples{

#stat_list<-handle_gsod(action="list_stations",location=c(x=-122,y=38.5),
#  time_interval=c(2002,2002))
#the line above takes longer to run than CRAN allows for examples. The line below therefore
#generates an abbreviated stat_list that allows running the code.
stat_list<-data.frame(chillR_code=c("724828_99999","724828_93241","720576_174"),
   Lat=c(38.383,38.378,38.533),Long=c(-121.967,-121.958,-121.783),
   BEGIN=c(20010811,20060101,20130101),END=c(20051231,20160110,20160109))

gw<-get_weather(location="724828_93241",time_interval=c(2012,2012),database="GSOD",
  station_list = stat_list)

#stat_list<-get_weather(location=c(lat=50,lon=10,ele=150),time_interval=c(2001,2001),
#  database="UCIPM")
#chillRcode<-stat_list[which(stat_list$Perc_interval_covered==
#max(stat_list$Perc_interval_covered)),"chillR_code"][1]
  #after the first few lines here, the code should be "CEDARVIL.C"
#gw<-get_weather(location="CEDARVIL.C",time_interval=c(2001,2001),database="UCIPM")
#weather<-weather2chillR(gw,"GSOD")
#make_chill_plot(tempResponse(stack_hourly_temps(fix_weather(weather))),
#                "Chill_Portions",start_year=2005,end_year=2011,metriclabel="Chill Portions")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ utilities }
