% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_models.R
\name{GDD}
\alias{GDD}
\title{Calculation of cumulative heat according to the Growing Degree Day Model}
\usage{
GDD(HourTemp, summ = TRUE, Tbase = 5)
}
\arguments{
\item{HourTemp}{Vector of hourly temperatures.}

\item{summ}{Boolean parameter indicating whether calculated metrics should
be provided as cumulative values over the entire record (TRUE) or as the
actual accumulation for each hour (FALSE).}

\item{Tbase}{Base temperature, above which Growing Degrees accrue.}
}
\value{
Vector of length length(HourTemp) containing the cumulative Growing
Degree Days over the entire duration of HourTemp.
}
\description{
This function calculates heat for temperate trees according to the Growing
Degree Day Model. Note that the calculuation differs slightly from the original,
in which it is based on daily temperature extremes only. This equation here works
with hourly temperatures. The normal GDD equation is GDD=(Tmax-Tmin)/2-Tbase, with
Tmax=30 for Tmax>30, and Tmin=10 for Tmin<10. Tbase is a species-specific base
temperature.
The first part of the equation is the arithmetic mean of daily temperature extremes.
In the present equation, this is replaced by Thourly/24 for each hourly temperature
value. If chillR was using a triangular daily temperature curve, the result would
be the same for both equations. Since chillR uses a sine function for daytime
warming and a logarithmic decay function for nighttime cooling, however, there
will be a slight deviation. This could be handled by defining a function the runs
with daily weather data. chillR doesn't currently have this capability, since
its primary focus is on metrics that require hourly data.
}
\details{
Growing Degree Hours are calculated as suggested by Anderson et al. (1986).
}
\examples{


weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])

hourtemps<-stack_hourly_temps(weather,latitude=50.4)

GDD(hourtemps$hourtemps$Temp)

}
\author{
Eike Luedeling
}
\references{
Growing Degree Days reference:

http://agron-www.agron.iastate.edu/Courses/agron212/Calculations/GDD.htm
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}

