% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle_dwd.R
\name{handle_dwd}
\alias{handle_dwd}
\title{List, download or convert to chillR format data from the Deutscher Wetterdienst database}
\usage{
handle_dwd(
  action,
  location = NA,
  time_interval = c(19160101, Date2YEARMODA(Sys.Date())),
  station_list = NULL,
  stations_to_choose_from = 25,
  drop_most = TRUE,
  end_at_present = TRUE,
  add.DATE = FALSE,
  quiet = FALSE,
  add_station_name = FALSE
)
}
\arguments{
\item{action}{is a character string to decide on 3 modes of action for the function.\itemize{

 \item{\emph{'list_stations'} returns a data frame with the information on weather stations that
 are to the location defined by \code{number_of_stations} and \code{location} parameters.}
       
 \item{\emph{'download_weather'} retrieves the records for one or more weather stations defined
 in the \code{location} parameter.}
 
 \item{If the input is a data frame previously downloaded with the mode \emph{'download_weather'},
 the function will format the data frame using the chillR structure.}}}

\item{location}{accepts a numeric vector with two or three elements representing the longitude,
latitude, and elevation of a given place or a vector of character strings representing the ID
of the weather stations of interest.
If \code{action = 'list_stations'}, \code{location} requires the coordinates of the place and
optionally the elevation. This vector can be named or not. Valid names are:
\code{'y'}, \code{'Y'}, \code{'latitude'}, \code{'lat'}, \code{'Latitude'}, \code{'Lat'},
\code{'LATITUDE'}, \code{'LAT'} for latitude, \code{'x'},
\code{'X'}, \code{'longitude'}, \code{'long'}, \code{'Longitude'}, \code{'Long'},
\code{'LONGITUDE'}, \code{'LONG'} for longitude, and \code{'z'}, \code{'Z'}, \code{'elevation'},
\code{'elev'}, \code{'Elevation'}, \code{'Elev'}, \code{'ELEVATION'},
\code{'ELEV'} for elevation. If \code{action = 'download_weather'}, \code{location} accepts
the ID of the station as character string.}

\item{time_interval}{numeric vector with two elements, specifying the start and end date
of the period of interest. Only required when running in \code{'list_stations'} or
\code{'download_weather'} mode. Unlike other functions from the handle family,
\code{handle_dwd} allows specifying the date in \code{YEARMODA} format. Default is set to
\code{19160101} (the earliest date on record) and the current date.}

\item{station_list}{accepts a data frame if the list of weather stations has already been
downloaded. The list can be passed to the function through this argument. This can save a bit
of time, since it can take a bit of time to download the list, which can have several
\code{MB}.}

\item{stations_to_choose_from}{if the location is specified by geographic coordinates,
this argument 
determines the number of nearby stations in the list that is returned.}

\item{drop_most}{boolean variable indicating if most columns should be dropped from the
file if a list of data frames is provided to the \code{action} argument. If set to
\code{TRUE} (the default), only essential columns for running \code{chillR} functions are
retained.}

\item{end_at_present}{boolean variable indicating whether the interval of interest
should end on the present day, rather than extending until the end of the year specified
under \code{time_interval[2]} (if \code{time_interval[2]} is the current year).
\strong{DEPRECATED} in this function since \code{time_interval} already allows specifying
the present day.}

\item{add.DATE}{is a boolean parameter to be passed to \code{\link{make_all_day_table}}
if \code{action} is a collection of outputs (in the form of list) from the function in the
downloading format.}

\item{quiet}{is a boolean parameter to be passed to
\code{\link[utils:download.file]{download.file}} if \code{action = "download_weather"}.}

\item{add_station_name}{is a boolean parameter to include the name of the respective weather
station in the resulting data frame in case the function is used in the downloading or
formatting mode.}
}
\value{
If \code{action = 'list_stations'}, the function returns a data frame with
\code{'stations_to_choose_from'} rows and 9 columns. This data frame contains information
about the weather stations (Latitude, Longitude, among others). If
\code{action = 'download_weather'}, the function returns a list of length according to the
length of the \code{location} parameter. Each list, is a list of two elements; a data frame
containing the data downloaded from the database and character string representing the
respective database ('dwd'). If the \code{action} is provided with the list generated by
the function in the downloading mode, the function will return a list of data frames structured
according to the chillR format. If \code{drop_most} is set to \code{TRUE}, the function will
keep only the relevant variables.
}
\description{
This function accesses the
\href{https://www.dwd.de/EN/climate_environment/cdc/cdc_node_en.html}{Deutscher
Wetterdienst database} and allows to:\itemize{\item{1) list a number of weather
stations that are close to a specific position (geographic coordinates)} \item{2) obtain
weather data for one or more weather stations through the station ID} \item{3) 'clean' and
'format' downloaded data, so the records can easily be used in other chillR functions}}
}
\note{
Many databases have data quality flags, which may sometimes indicate that data aren't reliable.
These are not considered by this function!
}
\examples{

# The following lines may take longer than required to pass the
# CRAN checks. Please, un-comment them to run the example

# stations <- handle_dwd(action = "list_stations", 
#                        location = c(latitude = 53.5373, longitude = 9.6397),
#                        time_interval = c(20000101, 20101231),
#                        stations_to_choose_from = 25)
                     
# data <- handle_dwd(action = "download_weather",
#                     location = stations[1 : 3, "Station_ID"],
#                     time_interval = c(20000101, 20020601),
#                     stations_to_choose_from = 25,
#                     station_list = stations,
#                     drop_most = TRUE, 
#                     add.DATE = FALSE,
#                     quiet = TRUE,
#                     add_station_name = FALSE)

# data_modified <- handle_dwd(data, add.DATE = TRUE, drop_most = TRUE)
           
}
\references{
Fernandez, E., Whitney, C., and Luedeling, E. 2020. The importance of chill model selection
- A multi-site analysis. European Journal Of Agronomy 119: 126103
}
\author{
Eduardo Fernandez and Eike Luedeling
}
\keyword{utilities}
\keyword{weather-data}
