% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precip_indices.R
\name{precip_indices}
\alias{precip_indices}
\title{Compute precipitation indices over a time series.}
\usage{
precip_indices(object, timeseries = FALSE, intervals = NULL)
}
\arguments{
\item{object}{an object of class \code{chirps} as provided by
\code{\link{get_chirps}}}

\item{timeseries}{logical, \code{FALSE} for a single point time series
observation or \code{TRUE} for a time series based on \var{intervals}}

\item{intervals}{integer no lower than 5, for the days intervals when
\var{timeseries} = \code{TRUE}}
}
\value{
A dataframe with precipitation indices:
\item{MLDS}{maximum length of consecutive dry day, rain < 1 mm (days)}
\item{MLWS}{maximum length of consecutive wet days, rain >= 1 mm (days)}
\item{R10mm}{number of heavy precipitation days 10 >= rain < 20 mm (days)}
\item{R20mm}{number of very heavy precipitation days rain >= 20 (days)}
\item{Rx1day}{maximum 1-day precipitation (mm)}
\item{Rx5day}{maximum 5-day precipitation (mm)}
\item{R95p}{total precipitation when rain > 95th percentile (mm)}
\item{R99p}{total precipitation when rain > 99th percentile (mm)}
\item{Rtotal}{total precipitation (mm) in wet days, rain >= 1 (mm)}
\item{SDII}{simple daily intensity index, total precipitation divided by the
 number of wet days (mm/days)}
}
\description{
Compute precipitation indices over a time series.
}
\examples{
\donttest{
lonlat <- data.frame(lon = c(-55.0281,-54.9857),
                     lat = c(-2.8094, -2.8756))

dates <- c("2017-12-15", "2017-12-31")

dt <- get_chirps(lonlat, dates)

# take the indices for the entire period
precip_indices(dt, timeseries = FALSE)

# take the indices for periods of 7 days
precip_indices(dt, timeseries = TRUE, intervals = 7)

}
}
\references{
Aguilar E., et al. (2005). Journal of Geophysical Research, 110(D23), D23107.
 \cr\url{https://doi.org/10.1029/2005JD006119}

Kehel Z., et al. (2016). In: Applied Mathematics and Omics to Assess Crop
 Genetic Resources for Climate Change Adaptive Traits (eds Bari A., Damania
 A. B., Mackay M., Dayanandan S.), pp. 151–174. CRC Press.
}
