% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare.R
\name{chisquare}
\alias{chisquare}
\title{R function for chi-square test of independence}
\usage{
chisquare(data, B = 999, format = "short")
}
\arguments{
\item{data}{Dataframe containing the input contingency table.}

\item{B}{Number of simulated tables to be used to calculate the Monte Carlo-based p value (999 by default).}

\item{format}{Takes \emph{short} (default) if the dataset is a dataframe storing a contingency table; if the
input dataset is a dataframe storing two columns that list the levels of the two categorical variables,
\emph{long} will preliminarily cross-tabulate the levels of the categorical variable in the 1st column against
the levels of the variable stored in the 2nd column.}
}
\value{
The function produces a number of \strong{output tables}, which are nicely formatted with the help of the
\code{\link[formattable]{formattable}} function out from the the \emph{formattable} package.
The output tables are listed below:

 \itemize{
  \item Input contingency table
  \item Expected frequencies
  \item Cells' chi-square value
  \item Cells' contribution (in percent) to the chi-square statistic (cells in blue feature a larger-than-average
  contribution)
  \item Standardized residuals (RED for residuals smaller than -1.96, GREEN for residuals larger than +1.96)
  \item Adjusted standardized residuals (colour same as above)
  \item Table of output statistics, p values, and association measures
}

Also, the function returns a \strong{list containing the following elements}:
 \itemize{
  \item \emph{crosstab}: input contingency table
  \item \emph{exp.freq.}: table of expected frequencies
  \item \emph{chisq.values}: cells' chi-square value
  \item \emph{chisq.contrib.}: cells' contribution (in percent) to the chi-square statistic
  \item \emph{chisq.statistic}: observed chi-square value
  \item \emph{chisq.p.value}: p value
  \item \emph{chisq.p.value.perm.}: p value based on B permuted tables
  \item \emph{stand.resid.}: table of standardized residuals
  \item \emph{adj.stand.resid.}: table of adjusted standardized residuals
  \item \emph{Phi}: Phi coefficient (only for 2x2 tables)
  \item \emph{Phi signed}: signed Phi coefficient (only for 2x2 tables)
  \item \emph{Yule's Q}: Q coefficient (only for 2x2 tables)
  \item \emph{Cadj}: adjusted contigency coefficient C
  \item \emph{Cramer's V}: Cramer's V coefficient
  \item \emph{Cramer's Vbc}: bias-corrected Cramer's V coefficient
  \item \emph{w}: Cohen's w
  \item \emph{lambda (rows dep.)}: Goodman-Kruskal's lambda coefficient (considering the rows being the dependent variable)
  \item \emph{lambda (cols dep.)}: Goodman-Kruskal's lambda coefficient (considering the columns being the dependent variable)
  \item \emph{gamma}: Goodman-Kruskal's gamma coefficient
  \item \emph{gamma.p.value}: 2-sided p value for the Goodman-Kruskal's gamma coefficient
}

The following examples, using in-built datasets, can be run to fimiliarise with the function:\cr

-perform the test on the in-built 'social_class' dataset\cr
result <- chisquare(social_class)\cr

-perform the test on a 2x2 subset of the 'diseases' dataset\cr
mytable <- diseases[3:4,1:2]\cr
result <- chisquare(mytable)\cr

-perform the test on a 2x2 subset of the 'safety' dataset\cr
mytable <- safety[c(4,1),c(1,6)]\cr
result <- chisquare(mytable)\cr

-build a toy dataset in 'long' format (gender vs. opinion about death sentence)\cr
mytable <- data.frame(GENDER=c(rep("F", 360), rep("M", 340)),\cr
OPINION=c(rep("oppose", 235),\cr
         rep("favour", 125),\cr
         rep("oppose", 160),\cr
         rep("favour", 180)))\cr

-perform the test, specifying that the input table is in 'long' format\cr
result <- chisquare(mytable, format="long")\cr
}
\description{
The function performs the chi-square test of independence on the input contingency table,
calculates various measures of categorical association, and returns standardized and adjusted
standardized residuals. The p value associated to the chi-square statistic is also calculated on the basis
of a permutation-based procedure. Nicely-formatted output tables are rendered.
}
\details{
The following \strong{measures of categorical associations} are produced by the function:
 \itemize{
  \item Phi (only for 2x2 tables)
  \item Phi signed (only for 2x2 tables)
  \item Yule's Q (only for 2x2 tables)
  \item Adjusted contingency coefficient C
  \item Cramer's V
  \item Bias-corrected Cramer's V
  \item Cohen's w
  \item Goodman-Kruskal's lambda (asymmetric)
  \item Goodman-Kruskal's gamma
}

The \strong{p value} of the observed chi-square statistic is also calculated on the basis of a permutation-based approach,
using B random tables created under the Null Hypothesis of independence. For the rationale of this approach,
see for instance the description in Beh E.J., Lombardo R. 2014, Correspondence Analysis: Theory, Practice
and New Strategies, Chichester, Wiley, pages 62-64.\cr

The \strong{randomized p value} is calculated as follows: \cr
\eqn{(1 + sum (chistat.perm > chisq.stat)) / (1 + B)}, where
\emph{chistat.perm} is a vector storing the B chi-square statistics generated under the Null Hypothesis, and
\emph{chisq.stat} is the observed chi-square statistic. For the logic of the calculation, see for example
Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press 2016: 387.\cr

The \strong{adjusted standardized residuals} are calculated as follows: \cr
\eqn{stand.res[i,j] / sqrt((1-sr[i]/n)*(1-sc[j]/n))}, where \emph{stand.res} is the standardized residual for cell \emph{ij},
\emph{sr} is the row sum for row \emph{i}, \emph{sc} is the column sum for column \emph{j}, and
\emph{n} is the table grand total. The \emph{adjusted standardized residuals} may prove useful since it has
been demonstrated that the standardized residuals tend to underestimate the significance of differences in small samples.
The adjusted standardized residuals correct that deficiency.\cr

The \strong{bias-corrected Cramer's V} is based on Bergsma, Wicher (2013).
"A bias correction for Cramér's V and Tschuprow's T". Journal of the Korean Statistical Society. 42 (3): 323–328,
https://doi.org/10.1016%2Fj.jkss.2012.10.002\cr

For the \strong{other measures of categorical association} provided by the function, see for example
Sheskin, D. J. (2011). Handbook of Parametric and Nonparametric Statistical Procedures, Fifth Edition (5th ed.). Chapman and Hall/CRC: 675-679,
1415-1427.\cr

\strong{Note} that the \emph{Phi} coefficient is based on the chi-square statistic as per Sheskin's equation 16.21, whereas the
\emph{Phi signed} is after Sheskin's equation 16.20. The \emph{2-tailed} p value of \emph{Goodman-Kruskal's gamma} is based on the
associated z-score calculated as per Sheskin's equation 32.2.
}
\examples{
#perform the test on the in-built 'diseases' dataset
result <- chisquare(diseases, B=99)


}
\keyword{chiperm}
