% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-data.R
\name{chk_data}
\alias{chk_data}
\alias{vld_data}
\title{Check Data}
\usage{
chk_data(x, x_name = NULL)

vld_data(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks data.frame using

\code{inherits(x, "data.frame")}
}
\section{Functions}{
\itemize{
\item \code{vld_data}: Validate Data
}}

\examples{
# chk_data
chk_data(data.frame(x = 1))
try(chk_data(1))
# vld_data
vld_data(data.frame())
vld_data(data.frame(x = 1))
vld_data(c(x = 1))
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_function}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
