% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-join.R
\name{chk_join}
\alias{chk_join}
\alias{vld_join}
\title{Check Join}
\usage{
chk_join(x, y, by, x_name = NULL)

vld_join(x, y, by)
}
\arguments{
\item{x}{The object to check.}

\item{y}{A data.frame with columns in by.}

\item{by}{A character vector specifying the column names to join x and y on.
If named the names are the corresponding columns in x.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all rows in x match at least one in y.
}
\section{Functions}{
\itemize{
\item \code{vld_join()}: Validate Join

}}
\examples{
# chk_join
chk_join(data.frame(z = 1), data.frame(z = 1:2), by = "z")
try(chk_join(data.frame(z = 1), data.frame(z = 2), by = "z"))
# vld_join
vld_join(data.frame(z = 1), data.frame(z = 1:2), by = "z")
vld_join(data.frame(z = 1), data.frame(z = 2), by = "z")
vld_join(data.frame(z = 1), data.frame(a = 1:2), by = c(z = "a"))
vld_join(data.frame(z = 1), data.frame(a = 2), by = c(z = "a"))
}
\seealso{
Other chk_set: 
\code{\link{chk_not_subset}()},
\code{\link{chk_orderset}()},
\code{\link{chk_superset}()},
\code{\link{vld_not_subset}()},
\code{\link{vld_orderset}()}
}
\concept{chk_set}
