% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_lmer.R
\name{add_pi.lmerMod}
\alias{add_pi.lmerMod}
\title{Prediction Intervals for Linear Mixed Model Fitted Values}
\usage{
\method{add_pi}{lmerMod}(
  tb,
  fit,
  alpha = 0.05,
  names = NULL,
  yhatName = "pred",
  type = "parametric",
  includeRanef = TRUE,
  log_response = FALSE,
  nSims = 10000,
  ...
)
}
\arguments{
\item{tb}{A tibble or data frame of new data}

\item{fit}{An object of class \code{lmerMod}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the predictions vector.}

\item{type}{A string, either \code{"parametric"} or
\code{"boot"}. Determines the method used to calculate the
prediction intervals.}

\item{includeRanef}{A logical. Set whether the predictions and
intervals should be conditioned on the random effects. If
\code{FALSE}, random effects will not be included.}

\item{log_response}{A logical, indicating if the response is on log
scale in the model fit. If \code{TRUE}, prediction intervals
will be returned on the response scale.}

\item{nSims}{A positive integer. If \code{type = "boot"},
\code{nSims} will determine the number of bootstrap simulations
to perform.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods in \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{lmerMod}.
}
\details{
It is recommended that one use parametric prediction intervals when
modeling with a random intercept linear mixed model. Otherwise,
prediction intervals may be simulated via a parametric bootstrap
using the function \code{lme4.simulate()}.
}
\examples{
dat <- lme4::sleepstudy
# Fit a (random intercept) linear mixed model
fit <- lme4::lmer(Reaction ~ Days + (1|Subject), data = lme4::sleepstudy)
# Add 50\% prediction intervals to the original data using the default
# method.
add_pi(dat, fit, alpha = 0.5)

# Add 50\% prediction intervals to the original data using the
# parametric bootstrap method. Form prediction intervals at the population
# level (unconditional on the random effects).
add_pi(dat, fit, alpha = 0.5, type = "boot", includeRanef = FALSE)

}
\seealso{
\code{\link{add_ci.lmerMod}} for confidence intervals
    for \code{lmerMod} objects, \code{\link{add_probs.lmerMod}} for
    conditional probabilities of \code{lmerMod} objects, and
    \code{\link{add_quantile.lmerMod}} for response quantiles of
    \code{lmerMod} objects.
}
