% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_glmer.R
\name{add_probs.glmerMod}
\alias{add_probs.glmerMod}
\title{Response Probabilities for Generalized Linear Mixed Model Predictions}
\usage{
\method{add_probs}{glmerMod}(
  df,
  fit,
  q,
  name = NULL,
  yhatName = "pred",
  comparison = "<",
  type = "boot",
  includeRanef = TRUE,
  nSims = 10000,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{glmerMod}.}

\item{q}{A double. A quantile of the response distribution.}

\item{name}{\code{NULL} or character vector of length one. If
\code{NULL}, response probabilities automatically will be named
by \code{add_probs},}

\item{yhatName}{\code{NULL} or a string. Name of the predictions
vector.}

\item{comparison}{A string. If \code{comparison = "<"}, then
\eqn{Pr(Y|x < q)} is calculated for each observation in
\code{df}. Default is "<". Must be "<" or ">" for objects of
class \code{lm} or \code{lmerMod}. If \code{fit} is a
\code{glm} or \code{glmerMod}, then \code{comparison} also may
be \code{"<="} , \code{">="} , or \code{"="}.}

\item{type}{A string. Must be \code{"boot"}, If \code{type =
"boot"}, then \code{add_ci} calls \code{lme4::simulate} to
calculate the probabilities.}

\item{includeRanef}{A logical. Default is \code{TRUE}. Set whether
the predictions and intervals should be made conditional on the
random effects. If \code{FALSE}, random effects will not be
included.}

\item{nSims}{A positive integer.  Controls the number of bootstrap
replicates if \code{type = "boot"}.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predicted values and estimated
    probabilities attached.
}
\description{
This function is one of the methods for \code{add_probs}, and is
called automatically when \code{add_probs} is used on a \code{fit}
of class \code{glmerMod}. Probabilities are approximate and
determined via a simulation. This function is experimental.
}
\details{
If \code{IncludeRanef} is False, random slopes and intercepts are set to 0. Unlike in
  `lmer` fits, settings random effects to 0 does not mean they are marginalized out. Consider
  generalized estimating equations if this is desired.
}
\examples{
n <- 300
x <- runif(n)
f <- factor(sample(1:5, size = n, replace = TRUE))
y <- rpois(n, lambda = exp(1 - 0.05 * x * as.numeric(f) + 2 * as.numeric(f)))
df <- data.frame(x = x, f = f, y = y)
fit <- lme4::glmer(y ~ (1+x|f), data=df, family = "poisson")

add_probs(df, fit, name = "p0.6", q = 0.6, nSims = 500)

}
\seealso{
\code{\link{add_pi.glmerMod}} for prediction intervals
    of \code{glmerMod} objects, \code{\link{add_ci.glmerMod}} for
    confidence intervals of \code{glmerMod} objects, and
    \code{\link{add_quantile.glmerMod}} for response quantiles of
    \code{glmerMod} objects.
}
