% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifpanel.R
\name{cifpanel}
\alias{cifpanel}
\title{Arrange multiple survival/CIF plots in a panel display}
\usage{
cifpanel(
  plots = NULL,
  formula = NULL,
  formulas = NULL,
  data = NULL,
  weights = NULL,
  subset.condition = NULL,
  na.action = na.omit,
  outcome.type = NULL,
  code.events = NULL,
  error = NULL,
  conf.type = NULL,
  conf.int = NULL,
  type.y = NULL,
  label.x = NULL,
  label.y = NULL,
  label.strata = NULL,
  order.strata = NULL,
  level.strata = NULL,
  limits.x = NULL,
  limits.y = NULL,
  breaks.x = NULL,
  breaks.y = NULL,
  add.conf = NULL,
  add.risktable = NULL,
  add.estimate.table = NULL,
  symbol.risk.table = NULL,
  font.size.risk.table = NULL,
  add.censor.mark = NULL,
  shape.censor.mark = NULL,
  size.censor.mark = NULL,
  add.competing.risk.mark = NULL,
  competing.risk.time = NULL,
  shape.competing.risk.mark = NULL,
  size.competing.risk.mark = NULL,
  add.intercurrent.event.mark = NULL,
  intercurrent.event.time = NULL,
  shape.intercurrent.event.mark = NULL,
  size.intercurrent.event.mark = NULL,
  add.quantile = NULL,
  level.quantile = NULL,
  rows.columns.panel = c(1, 1),
  inset.panel = FALSE,
  title.panel = NULL,
  subtitle.panel = NULL,
  caption.panel = NULL,
  tag.panel = NULL,
  title.plot = NULL,
  style = "classic",
  palette = NULL,
  linewidth = 0.8,
  linetype = FALSE,
  font.family = "sans",
  font.size = 8,
  legend.position = "top",
  legend.collect = TRUE,
  inset.left = 0.6,
  inset.bottom = 0.05,
  inset.right = 0.98,
  inset.top = 0.45,
  inset.align.to = c("panel", "plot", "full"),
  inset.legend.position = NULL,
  print.panel = FALSE,
  filename.ggsave = NULL,
  width.ggsave = NULL,
  height.ggsave = NULL,
  dpi.ggsave = 300,
  survfit.info = NULL,
  axis.info = NULL,
  visual.info = NULL,
  panel.info = NULL,
  style.info = NULL,
  inset.info = NULL,
  print.info = NULL,
  ggsave.info = NULL,
  engine = "cifplot",
  ...
)
}
\arguments{
\item{plots}{Optional list of existing ggplot objects to be arranged into a panel.
When plots is supplied, no new models are fitted; the plots are used as-is.}

\item{formula}{A model formula specifying the time-to-event outcome on the
left-hand side (typically \code{Event(time, status)} or \code{Surv(time, status)})
and, optionally, a stratification variable on the right-hand side.
Unlike \code{\link[=cifplot]{cifplot()}}, this function does not accept a fitted
\code{survfit} object.}

\item{formulas}{Optional list of formulas. When given, each formula defines
\strong{one panel}. This is the most common way to create “one variable per plot”
panels.}

\item{data}{A data frame containing variables in the formula.}

\item{weights}{Optional name of the weight variable in \code{data}. Weights must be nonnegative.}

\item{subset.condition}{Optional character string giving a logical condition to subset
\code{data} (default \code{NULL}).}

\item{na.action}{A function specifying the action to take on missing values (default \code{na.omit}).}

\item{outcome.type}{Character string specifying the type of time-to-event outcome.
One of \code{"survival"} (Kaplan-Meier) or \code{"competing-risk"} (Aalen-Johansen).
If \code{NULL} (default), the function automatically infers the outcome type from the data:
if the event variable has more than two unique levels, \code{"competing-risk"} is assumed;
otherwise, \code{"survival"} is used. You can also use abbreviations such as \code{"S"} or \code{"C"}.
Mixed or ambiguous inputs (e.g., \code{c("S", "C")}) trigger automatic detection based on the event coding.}

\item{code.events}{Optional numeric length-3 vector \code{c(event1, event2, censoring)}.
When supplied, it overrides \code{code.event1}, \code{code.event2}, and \code{code.censoring}
(primarily used when \code{\link[=cifpanel]{cifpanel()}} is called or when \code{panel.per.event = TRUE}).}

\item{error}{Character string specifying the method for SEs and CIs used internally.
For \code{"survival"} without weights, choose one of \code{"greenwood"} (default), \code{"tsiatis"}, or \code{"if"}.
For \code{"competing-risk"} without weights, choose one of \code{"delta"} (default), \code{"aalen"}, or \code{"if"}.
SEs and CIs based on influence functions (\code{"if"}) is recommended for weighted analysis.}

\item{conf.type}{Character specifying the method of transformation for CIs
used internally (default \verb{arcsine-square root}).}

\item{conf.int}{Numeric two-sided level of CIs (default \code{0.95}).}

\item{type.y}{Character string specifying the y-scale. For survival/CIF curves,
\code{"surv"} implies survival probabilities and \code{"risk"} implies CIF
(1-survival in simple survival settings). Specify \code{"cumhaz"} to plot cumulative hazard
or \code{"cloglog"} to generate a complementary log-log plot.
If \code{NULL}, a default is chosen from \code{outcome.type} or the survfit object.}

\item{label.x}{Character x-axis label (default \code{"Time"}).}

\item{label.y}{Character y-axis label (default is chosen automatically from \code{outcome.type}
and \code{type.y}, e.g. "Survival", "Cumulative incidence" or "Cumulative hazard").}

\item{limits.x}{Numeric length-2 vector specifying x-axis limits. If \code{NULL}, it is
set from the fitted object (typically \code{c(0, max(time))}).}

\item{limits.y}{Numeric length-2 vector specifying y-axis limits. If \code{NULL}, it is
set to \code{c(0, 1)} for probability-type outcomes.}

\item{breaks.x}{Numeric vector of x-axis breaks (default \code{NULL}).}

\item{breaks.y}{Numeric vector of y-axis breaks (default \code{NULL}).}

\item{add.conf}{Logical; if \code{TRUE}, adds a CI ribbon
(via \code{ggsurvfit::add_confidence_interval()}). Default \code{TRUE}.}

\item{add.censor.mark}{Logical; if \code{TRUE}, draws censoring marks on each curve
(via \code{ggsurvfit::add_censor_mark()}). Default \code{TRUE}.}

\item{shape.censor.mark}{Integer point shape used for censoring marks (default \code{3}).}

\item{size.censor.mark}{Numeric point size used for censoring marks (default \code{2}).}

\item{add.competing.risk.mark}{Logical; if \code{TRUE}, draws time marks for the competing event
(event 2). If no times are supplied via \code{competing.risk.time}, the function tries to
extract them automatically from the data. Default \code{FALSE}.}

\item{competing.risk.time}{A \strong{named list} of numeric vectors. Each name must correspond to a
strata label, and its numeric vector gives the times at which the competing event occurred
in that stratum. Typically left as \code{list()} and filled internally.}

\item{shape.competing.risk.mark}{Integer point shape for competing-risk marks (default \code{16}).}

\item{size.competing.risk.mark}{Numeric point size for competing-risk marks (default \code{2}).}

\item{add.intercurrent.event.mark}{Logical; if \code{TRUE}, overlays user-specified intercurrent-event
times per stratum. Default \code{FALSE}.}

\item{intercurrent.event.time}{A \strong{named list} of numeric vectors for intercurrent events
(names must match strata labels).}

\item{shape.intercurrent.event.mark}{Integer point shape for intercurrent-event marks
(default \code{1}).}

\item{size.intercurrent.event.mark}{Numeric point size for intercurrent-event marks
(default \code{2}).}

\item{add.quantile}{Logical; if \code{TRUE}, adds a quantile reference line (via
\code{ggsurvfit::add_quantile()}). Default \code{FALSE}.}

\item{level.quantile}{Numeric quantile level to be shown (default \code{0.5} for the median).}

\item{rows.columns.panel}{Optional integer vector \code{c(nrow, ncol)} controlling
the layout of the panel returned by the panel modes. If \code{NULL}, an automatic
layout is determined from the number of subplots.}

\item{inset.panel}{Logical. If \code{FALSE} (default), all panels are arranged
in a regular grid using \code{patchwork::wrap_plots()} and \code{plot_layout()}.
If \code{TRUE}, the function switches to “inset mode”: the \strong{first} plot becomes
the main plot and the \strong{second} plot (only the second) is drawn on top of it
as an inset. Additional plots beyond the second are ignored in inset mode.
Use grid mode to display more than two panels (\code{inset.panel = FALSE}).}

\item{title.panel, subtitle.panel, caption.panel}{Character annotations applied to the
\strong{whole} panel layout (not to individual plots). These are passed to
\code{patchwork::plot_annotation()} and are useful for creating figure-like
outputs (title + subfigures + caption).}

\item{tag.panel}{Passed to \code{patchwork::plot_annotation()} to auto-label
individual panels (e.g. \code{"A"}, \code{"B"}, \code{"C"}). Typical values are
\code{"A"}, \code{"1"}, or \code{"a"}. See \code{?patchwork::plot_annotation}.}

\item{title.plot}{Character vector of titles for \strong{each panel} in the order they
are drawn. Length-1 values are recycled to all panels. In inset mode, the first
element refers to the main plot and the second (if present) to the inset.}

\item{style}{Character choosing the base plot style: \code{"classic"}, \code{"bold"},
\code{"framed"}, \code{"grid"}, \code{"gray"} or \code{"ggsurvfit"} (default \code{"classic"}).
Abbreviations such as \code{"C"}, \code{"B"}, \code{"F"}, or \code{"G"} are also accepted.}

\item{palette}{Optional character vector specifying the color palette to use across strata.}

\item{linewidth}{Optional numeric specifying the line width of curve (default \code{0.8}).}

\item{linetype}{Optional logical using different line types of curve (default \code{FALSE}).}

\item{font.family}{Character specifying the font family: \code{"sans"},  \code{"serif"}, or
\code{"mono"} (default \code{"sans"}).}

\item{font.size}{Integer specifying the base font size (default \code{12}).}

\item{legend.collect}{Logical; if \code{TRUE}, try to collect a single legend
for all panels (passed to \pkg{patchwork}). Default \code{TRUE}.}

\item{inset.left, inset.bottom, inset.right, inset.top}{Numeric values in the range
\verb{[0, 1]} that define the inset box as fractions of the reference area.
\code{inset.left} / \code{inset.right} control the horizontal position,
\code{inset.bottom} / \code{inset.top} control the vertical position.
Values are interpreted as “from the left/bottom” of the reference.
For example, \code{inset.left = 0.4}, \code{inset.right = 1.0} draws the inset
over the right 60\% of the reference area.}

\item{inset.align.to}{Character string specifying the coordinate system for the
inset box. One of \code{"panel"} (default; the box is placed relative to the panel
area, i.e. the plotting region excluding outer titles/margins),
\code{"plot"} (relative to the entire plot area, including axes and titles of the
main plot), or \code{"full"} (relative to the full patchwork canvas).
This argument is passed to \code{patchwork::inset_element()}.}

\item{inset.legend.position}{Optional legend position \strong{for the inset plot only}.
If \code{NULL} (default), the inset plot keeps whatever legend position was
defined for it (often this means a legend will also be inset).
Set, for example, \code{"none"} to hide the legend inside the inset,
while still showing the main plot's legend.}

\item{print.panel}{Logical. When \code{TRUE}, panel displays created internally are
printed automatically in interactive sessions; otherwise they are returned
invisibly for further modification (default \code{FALSE}).}

\item{filename.ggsave}{Character; if non-\code{NULL}, save the plot to this file.}

\item{width.ggsave}{Numeric width passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{height.ggsave}{Numeric height passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{dpi.ggsave}{Numeric DPI passed to \code{ggplot2::ggsave()} (default \code{300}).}

\item{survfit.info, axis.info, visual.info, panel.info, style.info, print.info, ggsave.info, inset.info}{Internal lists used for programmatic control. Not intended for direct user input.}

\item{...}{Additional arguments forwarded to the internal \code{cifplot_single()}
calls that build each panel. Use this to pass low-level options such as
\code{competing.risk.time}, \code{intercurrent.event.time}, or styling overrides.}
}
\value{
A \code{"cifpanel"} object (returned invisibly), which is a list
with at least the following elements:
\itemize{
\item \code{list.plot}: a list of ggplot objects, one per panel
\item \code{patchwork}: a patchwork object representing the composed panel
\item \code{plot}: reserved for backwards compatibility (always \code{NULL})
\item metadata fields mirroring those in \code{\link[=cifplot]{cifplot()}} (such as information
on the fitted curves and display settings)
}

When \code{print.panel = TRUE}, the patchwork object is printed in interactive
sessions in addition to being returned.
}
\description{
\code{\link[=cifpanel]{cifpanel()}} is the panel-building counterpart of \code{\link[=cifplot]{cifplot()}}.
It takes one or more model formulas (or, alternatively, one formula and several
event-coding specifications) and returns a multi-panel figure, typically as a
patchwork-compatible object. Most display options (axis labels, marks, style, ggsave options)
are shared with \code{\link[=cifplot]{cifplot()}}, but per-panel legends and number-at-risk tables are
suppressed to avoid duplicated display. Typical use cases are:
\itemize{
\item Compare CIF (event 1) vs CIF (event 2) in a 1×2 layout.
\item Compare survival/CIF curves across strata with a shared legend and matched axes.
\item Display a plot with an enlarged y-axis inside a full-scale plot.
}
}
\details{
\subsection{Overview}{

\code{cifpanel()} composes multiple survival/CIF plots into a single figure.
For each panel, it estimates curves via \code{cifcurve()} and renders them with
\code{cifplot()}. You can supply a single \code{formula} reused across panels or a
list in \code{formulas} (one per panel). When both are provided, \code{formulas} wins.
}

\subsection{Outcome type & event coding}{
\itemize{
\item Use \code{outcome.type} to set per-panel estimator (\code{"survival"}=KM, \code{"competing-risk"}=AJ).
\item Alternatively, pass \code{code.events} per panel to infer the type:
\itemize{
\item length 2 = survival: \code{c(event1, censor)}
\item length 3 = competing-risk: \code{c(event1, event2, censor)}
}
\item If \code{outcome.type} is \code{NULL}, the function infers each panel from its
\code{code.events[[i]]} length. When both are given, \code{outcome.type} takes precedence.
}
}

\subsection{Panel-wise vs shared arguments}{

Panel layout is specified by length-2 vector \code{rows.columns.panel}.
This function can also automatically determine the panel count in the following order:
(1) if \code{plots} is supplied, its length defines the number of plots,
(2) else if \code{formulas} is supplied, its length defines the number of plots,
(3) else if \code{code.events} is supplied, its length defines the number of plots
together with formula, and (4) otherwise \code{rows.columns.panel=c(1,1)}.

Many arguments accept a \strong{scalar} (recycled to all panels) or a \strong{list/vector}
(one entry per panel). Precedence: \strong{panel-wise explicit values} >
\strong{shared scalar} > \strong{internal defaults}. Length-1 inputs are recycled.
}

\subsection{Grid vs inset composition}{
\itemize{
\item \strong{Grid mode} (\code{inset.panel = FALSE}, default): plots are arranged with
\code{patchwork::wrap_plots()} and \code{plot_layout()}. If \code{legend.collect = TRUE},
legends are collected across panels where possible.
\item \strong{Inset mode} (\code{inset.panel = TRUE}): the \strong{second} plot is overlaid
into the \strong{first} using \code{patchwork::inset_element()}. Only the first two
plots are used; extra plots are ignored. Control the inset box with
\code{inset.left}, \code{inset.bottom}, \code{inset.right}, \code{inset.top}, and its
reference frame via \code{inset.align.to} (\code{"panel"}, \code{"plot"}, or \code{"full"}).
}
}

\subsection{Advanced panel controls (forwarded to \code{cifplot()})}{

The following arguments allow \strong{per-panel} control by supplying vectors/lists,
or \strong{shared} control by supplying scalars. They are forwarded to \code{cifplot()}.
\itemize{
\item \code{formula} or \code{formulas}: one formula or a list of formulas; each entry creates a panel.
\item \code{data}, \code{outcome.type}, \code{code.events}, \code{type.y}: recycled across panels unless a list is supplied for per-panel control.
\item \code{rows.columns.panel}: specification of grid layout by c(rows, cols).
\item \code{inset.panel}: inset layout.
\item \code{title.panel}, \code{subtitle.panel}, \code{caption.panel}, \code{title.plot}: overall titles and captions.
\item \code{tag.panel}: panel tag style (e.g., "A", "a", "1").
\item \code{label.x}, \code{label.y}, \code{limits.x}, \code{limits.y}, \code{breaks.x}, \code{breaks.y}: shared axis control unless a list is supplied for per-panel control.
}
\subsection{Scale & labels}{\tabular{lll}{
   Argument \tab Meaning \tab Default \cr
   \code{type.y} \tab \code{"risk"} (CIF y-axis) or \code{NULL} (survival). \tab inferred \cr
   \code{label.x}, \code{label.y} \tab Axis labels per panel. \tab auto \cr
   \code{label.strata} \tab Legend labels per panel. \tab from data \cr
   \code{limits.x}, \code{limits.y} \tab Axis limits \code{c(min, max)}. \tab auto \cr
   \code{breaks.x}, \code{breaks.y} \tab Axis breaks (forwarded to \code{breaks.x}/\code{breaks.y}). \tab auto \cr
}

}

\subsection{Plot layers (toggles)}{\tabular{lll}{
   Argument \tab Effect \tab Default \cr
   \code{add.conf} \tab CI ribbon. \tab \code{TRUE} \cr
   \code{add.censor.mark} \tab Censor marks. \tab \code{TRUE} \cr
   \code{add.competing.risk.mark} \tab Marks for event2 at supplied times. \tab \code{FALSE} \cr
   \code{add.intercurrent.event.mark} \tab User-specified intercurrent marks. \tab \code{FALSE} \cr
   \code{add.quantile} \tab Quantile reference line(s). \tab \code{FALSE} \cr
}


\emph{(Time marks inputs such as \code{competing.risk.time} / \code{intercurrent.event.time}
can be given via \code{...} if needed; names must match strata labels.)}
}

}

\subsection{Legend & annotations}{
\itemize{
\item \code{legend.position}: \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"}, or \code{"none"} (applies to all panels).
\item Grid mode: \code{legend.collect = TRUE} attempts a shared legend.
\item Panel annotations: \code{title.panel}, \code{subtitle.panel}, \code{caption.panel}.
\item Tagging: \code{tag.panel} is passed to \code{patchwork::plot_annotation()}.
\item In inset mode, \code{title.plot = c(title_base, title_inset)} labels the two plots.
}
}

\subsection{Export (optional)}{

If \code{filename.ggsave} is non-\code{NULL}, the composed panel is saved with
\code{ggsave()} using \code{width.ggsave}, \code{height.ggsave}, and \code{dpi.ggsave}.
Otherwise, the function returns objects without saving.

\strong{Notes}
\itemize{
\item Mixed panel types are supported (e.g., AJ in panel 1; KM in panel 2).
\item If \code{formulas} is shorter than the grid capacity, empty slots are ignored.
\item When supplying vectors/lists per panel, their lengths must match the number
of panels; length-1 inputs are recycled; otherwise an error is thrown.
\item For CIF displays, set \code{type.y = "risk"}. For survival scale, use \code{type.y = NULL} or \verb{= "surv"}.
For ADaM-style data, use \code{code.events=c(0,1)} or
\code{code.event1 = 0}, \code{code.censoring = 1}.
\item Additional graphical options (e.g., theme) can be added post-hoc to each
element of \code{list.plot} or to the composed \code{patchwork}.
}
}
}
\section{Lifecycle}{

\lifecycle{experimental}
}

\examples{
data(diabetes.complications)
output1 <- cifpanel(
  title.panel = "A comparison of cumulative incidence of competing events",
  rows.columns.panel = c(1,2),
  formula = Event(t, epsilon) ~ fruitq,
  data = diabetes.complications,
  outcome.type = "competing-risk",
  code.events = list(c(1,2,0), c(2,1,0)),
  label.y = c("Diabetic retinopathy", "Macrovascular complications"),
  label.x = "Years from registration",
  subtitle.panel = "Stratified by fruit intake",
  caption.panel  = "Data: diabetes.complications",
  title.plot = c("Diabetic retinopathy", "Macrovascular complications"),
  legend.position = "bottom",
  legend.collect=TRUE
)
print(output1)

output2 <- cifplot(Event(t,epsilon) ~ fruitq,
                   data = diabetes.complications,
                   outcome.type="competing-risk",
                   code.event1=2,
                   code.event2=1,
                   add.conf = FALSE,
                   add.risktable = FALSE,
                   label.y="CIF of macrovascular complications",
                   label.x="Years from registration")
output3 <- cifplot(Event(t,epsilon) ~ fruitq,
                   data = diabetes.complications,
                   outcome.type="competing-risk",
                   code.event1=2,
                   code.event2=1,
                   add.conf = FALSE,
                   add.risktable = FALSE,
                   label.y="",
                   label.x="",
                   limits.y=c(0,0.15))
output4 <- list(a = output2$plot, b = output3$plot)
output5 <- cifpanel(plots = output4,
         inset.panel = TRUE,
         inset.left = 0.40, inset.bottom = 0.45,
         inset.right = 1.00, inset.top = 0.95,
         inset.align.to = "plot",
         inset.legend.position = "none",
         legend.position = "bottom")
print(output5)

}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log-odds product modeling of CIFs; \code{\link[=cifcurve]{cifcurve()}} for KM/AJ estimators; \code{\link[=cifplot]{cifplot()}} for display of a CIF; \link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit}, \link[patchwork:patchwork-package]{patchwork::patchwork} and \link[modelsummary:modelsummary]{modelsummary::modelsummary} for display helpers.
}
\keyword{internal}
