% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circacompare_mixed.R
\name{circacompare_mixed}
\alias{circacompare_mixed}
\title{circacompare_mixed}
\usage{
circacompare_mixed(
  x,
  col_time,
  col_group,
  col_outcome,
  col_id,
  randomeffects = c(),
  period = 24,
  alpha_threshold = 0.05,
  nlme_control = list(),
  nlme_method = "REML",
  verbose = FALSE,
  timeout_n = 10000,
  control = list()
)
}
\arguments{
\item{x}{\code{data.frame}.  This is the data.frame which contains the rhythmic data for two groups in a tidy format.}

\item{col_time}{The name of the column within the data.frame, \code{x}, which contains time in hours at which the data were collected.}

\item{col_group}{The name of the column within the data.frame, \code{x}, which contains the grouping variable.  This should only have two levels.}

\item{col_outcome}{The name of the column within the data.frame, \code{x}, which contains outcome measure of interest.}

\item{col_id}{The name of the column within the data.frame, \code{x}, which contains the identifying values for the random effect, such as \code{subject_id}.}

\item{randomeffects}{which rhythmic parameters to allow random effects. The default is to include no rhythmic parameters.}

\item{period}{The period of the rhythm. For circadian rhythms, leave this as the default value, \code{24}.}

\item{alpha_threshold}{The level of alpha for which the presence of rhythmicity is considered. Default is to \code{0.05}.}

\item{nlme_control}{A list of control values for the estimation algorithm to replace the default values returned by the function nlme::nlmeControl. Defaults to an empty list.}

\item{nlme_method}{A character string. If "REML" the model is fit by maximizing the restricted log-likelihood. If "ML" the log-likelihood is maximized. Defaults to "REML".}

\item{verbose}{An optional logical value. If \code{TRUE} information on the evolution of the iterative algorithm is printed. Default is \code{FALSE}.}

\item{timeout_n}{The upper limit for the model fitting attempts. Default is \code{10000}.}

\item{control}{\code{list}. Used to control the parameterization of the model.}
}
\value{
list
}
\description{
\code{circacompare_mixed} is similar to \code{circacompare} but allows for some simple, user-specified random-effects on the rhythmic parameters of choice.
}
\examples{
# Generate some data with within-id correlation for phase-shift (phi1)
set.seed(99)
phi1_in <- 3.15

mixed_data <- function(n){
  counter <- 1
  for(i in 1:n){
    x <- make_data(k1=0, alpha1=0, phi1=rnorm(1, phi1_in, 0.5), hours=72, noise_sd = 1)
    x$id <- counter
    counter <- counter + 1
    if(i==1){res <- x}else{res <- rbind(res, x)}
  }
  return(res)
}
df <- mixed_data(20)
out <- circacompare_mixed(
  x = df,
  col_time = "time",
  col_group = "group",
  col_outcome = "measure",
  col_id = "id",
  control=list(grouped_params=c("phi"), random_params=c("phi1"))
)
out
}
