% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{IC_compare.circGLM}
\alias{IC_compare.circGLM}
\title{Compare the information criteria of several circGLM models.}
\usage{
IC_compare.circGLM(
  ...,
  ICs = c("n_par", "lppd", "AIC_Bayes", "DIC", "DIC_alt", "WAIC1", "WAIC2", "p_DIC",
    "p_DIC_alt", "p_WAIC1", "p_WAIC2")
)
}
\arguments{
\item{...}{The \code{circGLM} objects to be compared.}

\item{ICs}{A character vector of ICs to display.}
}
\value{
A matrix with a column of information criteria for each model.
}
\description{
Compare the information criteria of several circGLM models.
}
\examples{
Xcat <- c(rep(0, 5), rep(1, 5))
th <- rvmc(10, 0, 4) + Xcat

# Compare a model that includes group differences with a model that does not.
IC_compare.circGLM(circGLM(th = th), circGLM(th = th, X = Xcat))
}
