% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{modalDirection}
\alias{modalDirection}
\title{Estimate the modal direction}
\usage{
modalDirection(th, modebw = 0.1)
}
\arguments{
\item{th}{A vector of angles in radians.}

\item{modebw}{Numeric between 0 and 1. The modes are estimated by taking the
midpoint of a highest density interval. Specifically, the mode is the
midpoint of the interval that contains \code{modebw} of the values of
\code{th}. Reasonable values are roughly between .005 and .2, although
lower values may be reasonable there are a lot of observations in
\code{th}.}
}
\value{
An angle in radians.
}
\description{
Estimates the mode as the midpoint of the highest density interval.
}
\details{
The highest density interval is computed as the shortest interval containing
\code{modebw} of the values in \code{th}. For circular data however, this
definition is not useful, and we should instead look for the shortest arc
that contains \code{modebw} of the data. This is done by rotating the data
such that the mean direction is \code{pi}, and then applying the usual linear
methods.
}
\examples{
modalDirection(rvmc(30, 0, 2))

}
