% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{ccGenomicDensity}
\alias{ccGenomicDensity}
\title{Create a track of density plot}
\usage{
ccGenomicDensity(
  data,
  ylim.force = FALSE,
  window.size = NULL,
  overlap = TRUE,
  count_by = c("percent", "number"),
  col = ifelse(area, "grey", "black"),
  lwd = par("lwd"),
  lty = par("lty"),
  type = "l",
  area = TRUE,
  area.baseline = NULL,
  baseline = 0,
  border = NA,
  ...
)
}
\arguments{
\item{data}{A bed-file-like data frame or a list of data frames. If the input is a list of data frames.
 there will be multiple density plot in one same track.
}

\item{ylim.force}{Whether to force upper bound of \code{ylim} to be 1. Ignored if \code{count_by} is set to \code{number}.
}

\item{window.size}{Pass to \code{\link[circlize]{genomicDensity}}.
}

\item{overlap}{Pass to \code{\link[circlize]{genomicDensity}}.
}

\item{count_by}{Pass to \code{\link[circlize]{genomicDensity}}.
}

\item{col}{Colors. It should be length of one. If \code{data} is a list of data frames, the length of \code{col}
 can also be the length of the list. If multiple sets of genomic regions are visualized in one
 single track, you should set the colors with transparency to distinguish them.
}

\item{lwd}{Width of lines, the same setting as \code{col} argument.
}

\item{lty}{Style of lines, the same setting as \code{col} argument.
}

\item{type}{Type of lines, see \code{\link[circlize]{circos.lines}}.
}

\item{area}{See \code{\link[circlize]{circos.lines}}.
}

\item{area.baseline}{Deprecated, use \code{baseline} instead.
}

\item{baseline}{See \code{\link[circlize]{circos.lines}}.
}

\item{border}{See \code{\link[circlize]{circos.lines}}.
}

\item{...}{Pass to \code{\link[circlize]{circos.trackPlotRegion}}.
}
}
\value{
Object \linkS4class{ccGenomicTrack}
}
\description{
Object \linkS4class{ccGenomicTrack} will call the function \link[circlize:circos.genomicDensity]{circlize::circos.genomicDensity} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
load(system.file(package = "circlize", "extdata", "DMR.RData"))
cc = ccPlot(initMode="initializeWithIdeogram", chromosome.index = paste0("chr", 1:22))
t2 = ccGenomicDensity(DMR_hyper, col = c("#FF000080"), track.height = 0.1)
t3 = ccGenomicDensity(DMR_hypo, col = c("#0000FF80"), track.height = 0.1)
cc + t2 + t3
circos.clear()
}
}
