% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccPoints}
\alias{ccPoints}
\title{Draw points in a region}
\usage{
ccPoints(
  x = NULL,
  y = NULL,
  pch = par("pch"),
  col = par("col"),
  cex = par("cex"),
  bg = par("bg")
)
}
\arguments{
\item{x}{Data points on x-axis, measured in "current" data coordinate}

\item{y}{Data points on y-axis, measured in "current" data coordinate}

\item{pch}{Point type}

\item{col}{Point color}

\item{cex}{Point size}

\item{bg}{backgrond of points}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.points]{circlize::circos.points} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track1 <- ccTrack(ylim = c(0, 1), panel.fun = function(x, y) {
  circos.points(runif(10), runif(10))
})
cells <- ccCell(sector.index = "a") + ccPoints(
  x = runif(10), y = runif(10),
   pch = 16, col = "red"
)
track1 <- track1 + cells
cc + track1
}
