# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

M_step_PKBD <- function(data, weights, mu_vec, rho, n, d, tol = 1e-6, maxiter = 100L) {
    .Call('_circlus_M_step_PKBD', PACKAGE = 'circlus', data, weights, mu_vec, rho, n, d, tol, maxiter)
}

logLik_PKBD <- function(data, mu_vec, rho) {
    .Call('_circlus_logLik_PKBD', PACKAGE = 'circlus', data, mu_vec, rho)
}

#' @title Random Sampling from PKBD Distributions using ACG Envelopes
#' @description Generates a random sample from PKBD distributions.
#' @param n The number of random draws.
#' @param rho A numeric giving the concentration parameter.
#' @param mu A numeric vector giving the mean direction parameter.
#' @return  A matrix with the generated values.
#' @rdname rPKBD_ACG
#' @useDynLib circlus
#' @importFrom Rcpp evalCpp
#' @keywords internal
rPKBD_ACG <- function(n, rho, mu) {
    .Call('_circlus_rPKBD_ACG', PACKAGE = 'circlus', n, rho, mu)
}

#' @title Random Sampling from Spherical Cauchy Distributions
#' @description Generates a random sample from spherical Cauchy distributions.
#' @param n The number of random draws.
#' @param rho A numeric value giving the rho parameter.
#' @param mu A numeric vector giving the mu direction parameter.
#' @return  A matrix with the generated values.
#' @rdname rspcauchy
#' @examples
#' rspcauchy(10, 0.95, c(1, 0, 0))
#' @export
rspcauchy <- function(n, rho, mu) {
    .Call('_circlus_rspcauchy', PACKAGE = 'circlus', n, rho, mu)
}

M_step_sCauchy <- function(data, weights, n, d, tol = 1e-6, maxiter = 100L) {
    .Call('_circlus_M_step_sCauchy', PACKAGE = 'circlus', data, weights, n, d, tol, maxiter)
}

logLik_sCauchy <- function(data, mu_vec, rho) {
    .Call('_circlus_logLik_sCauchy', PACKAGE = 'circlus', data, mu_vec, rho)
}

