% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_image_urls.R
\name{tag_image_urls}
\alias{tag_image_urls}
\title{Tag Remote Images}
\usage{
tag_image_urls(img_urls = NULL, meta = FALSE, simplify = TRUE)
}
\arguments{
\item{img_urls}{A string or character vector of URLs of images for which you want tags}

\item{meta}{Boolean that toggles whether or not you want the entire object.}

\item{simplify}{Boolean that toggles whether or not you want a simplified data frame with
each label and associated probability in a separate row. Default is TRUE.

The entire object returned by the API contains a lot of meta data. 
By default a simplified data.frame with img_url, associated labels, and probabilities is returned.}
}
\value{
If meta is TRUE, a named list of length 4 with following elements is returned: 
\code{status_code} OK or not
\code{status_msg}  Successful or not
\code{meta} Named list of 1 containing another list named \code{tag}
Sublist \code{tag} has three elements: timestamp, model and config
\code{results} is a data.frame of length 6 and 1 row. Column names are:
\code{docid}, \code{status_code}, \code{status_msg}, \code{local_id} and 
a data.frame named tag which has a data.frame result which contains two columns: 
labels and probabilities

If meta is FALSE and simplify is TRUE,
a data.frame with three columns: img_urls, labels and probs returned

If meta is FALSE and simplify is FALSE,
a data.frame with two columns carrying a vector of labels, vector of probs is returned
for each image
}
\description{
Tag Remote Images
}
\examples{
\dontrun{
tag_image_urls(img_url="url_of_image")
}
}
\references{
\url{https://developer.clarifai.com/}
}
\seealso{
\code{\link{tag_images}}
}

