% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccRecord.R
\docType{class}
\name{ccRecord-class}
\alias{ccRecord}
\alias{ccRecord-class}
\title{The S4 class which holds all the CCHIC patient record - served as a database.}
\description{
ccRecord is a class to hold the raw episode data parsed directly 
from XML or CSV files.
}
\section{Fields}{

\describe{
\item{\code{nepisodes}}{is an integer number indicates the total number of episode
the record is holding.}

\item{\code{dmgtb}}{a data.table containing all the demographic information of each
episode, including site_id, NHS number, PAS number, admission date/time,
and discharge date/time. This field is usually left empty.}

\item{\code{infotb}}{a data.table holding the parsing information of each episode such as the
parsing time and from which file it parsed from.}

\item{\code{episdoes}}{a list of ccEpisode objects.}
}}
\examples{
heart_rate <- data.frame(seq(10), rep(70, 10)) # NIHR_HIC_ICU_0108
site_id <- "Q70" #  NIHR_HIC_ICU_0002
episode_id <- "0000001" # NIHR_HIC_ICU_0005

# Create a new episode 
ep <- new.episode(list(NIHR_HIC_ICU_0108=heart_rate, 
                         NIHR_HIC_ICU_0002=site_id, 
                         NIHR_HIC_ICU_0005=episode_id)) 

# modifying records 
rec <- ccRecord() # a new record 
rec <- rec + ep # adding a new episode to the record
rec <- rec + NULL # adding nothing to the record
rec <- rec + rec # adding a record to a record
# Adding a list of episodes 
rec <- ccRecord()
ep1 <- new.episode()
ep2 <- new.episode()
eps.list <- list(ep1, ep2)
new.rec <- rec + eps.list
}

