% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_numeric.R
\name{convert_to_numeric}
\alias{convert_to_numeric}
\title{Convert columns into numeric}
\usage{
convert_to_numeric(data, target_columns = NULL, lang = c("en", "fr", "es"))
}
\arguments{
\item{data}{The input data frame or linelist}

\item{target_columns}{A vector of the target column names. When the input
data is a \code{linelist} object, this parameter can be set to \code{linelist_tags}
if the tagged columns are those to be converted into numeric.}

\item{lang}{The text's language. Currently one of \code{"en" | "fr" | "es"}.}
}
\value{
A data frame after the conversion process, wherein all the specified
or detected columns have been transformed into numeric format.
}
\description{
When the function is invoked without specifying the column names to be
converted, it automatically scans for columns containing exclusively missing,
numeric, and character values. Furthermore, it identifies columns where the
proportion of numeric values is at least twice the percentage of character
values and performs the conversion in them.
}
\examples{
dat <- convert_to_numeric(
  data           = readRDS(system.file("extdata", "messy_data.RDS",
                                       package = "cleanepi")),
  target_columns = "age",
  lang           = "en"
)
}
