% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precip_split.R
\name{precip_split}
\alias{precip_split}
\title{Splitting precipitation values to 6/12/24 hour periods and converting to numeric}
\usage{
precip_split(precip, pattern = "/12")
}
\arguments{
\item{precip}{vector of characters with precipitation field from Ogimet}

\item{pattern}{6h-12h-24h precipitation pattern to obtain written as: "/6h", "/12h" , "/24h" (see examples)}
}
\description{
Internal function for splitting precipitation field provided by Ogimet and converting string to numerical value
}
\examples{
\donttest{
 df = climate:::ogimet_hourly(station = 12330)
 climate:::precip_split(df$Precmm, pattern = "/12") # to get 12h precipitation amounts
}

}
\keyword{internal}
