% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_h.R
\encoding{UTF-8}
\name{plot_h}
\alias{plot_h}
\title{plot_h}
\usage{
plot_h(data, geo_id, col = "red", pch = 19, ...)
}
\arguments{
\item{data}{List. Containing climate, elevation and latitude
data sets. Structured by \code{ce_extract()}.}

\item{geo_id}{Character. Corresponding to a specific feature contained in the
\code{"location"} argument (specifically in the \code{"location_g"} column).}

\item{col, pch, \dots}{Arguments to control point styling in
\code{HoldridgePoints()}.}
}
\value{
Returns a base R family of plot. This function uses the \pkg{Ternary}
package to create a Holdridge simplex plot.
}
\description{
Creates a graph using the climate and elevation data which has
been extracted for a given \code{location}. It accepts the data formatted
from the \code{ce_extract} function.
}
\examples{
# Step 1. Import the Italian Biome polygon data
# Step 2. Run the download function
# Step 3. Run the extract function
#* See ce_download & ce_extract documentation

# Steps 1, 2 & 3 can be skipped by loading the extracted data (it_data)
data("it_data", package = "climenv")

# Step 4. Visualise the climatic envelope using a Holdridge diagram

plot_h(data = it_data, geo_id = "MED")

}
\references{
{ Holdridge (1947), Determination of world plant formations from
simple climatic data. \emph{Science}, 105:367–368.
\doi{10.1126/science.105.2727.367}

Holdridge (1967),
\emph{\href{https://reddcr.go.cr/sites/default/files/centro-de-documentacion/holdridge_1966_-_life_zone_ecology.pdf}{Life zone ecology}}.
Tropical Science Center, San José.

Smith, M.R (2017). Ternary: An R Package for Creating Ternary Plots.
Comprehensive R Archive Network. \doi{10.5281/zenodo.1068996}

}
}
\seealso{
Download climate data: \code{\link[=ce_download]{ce_download()}}
}
\author{
James L. Tsakalos and Martin R. Smith
}
