% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_results.R
\name{merge_results}
\alias{merge_results}
\title{Merge two slidingwin analyses.}
\usage{
merge_results(dataset1, dataset2)
}
\arguments{
\item{dataset1, dataset2}{The slidingwin outputs to be merged. Note that all elements 
(i.e. Dataset, BestModel, BestModelData) will be merged and do not need to be specified.}
}
\value{
A list object, identical to that produced by \code{\link{slidingwin}},
containing all records from both outputs.
}
\description{
Merges outputs of two separate slidingwin analyses.
}
\examples{
\dontrun{
 
data(Offspring) 
data(OffspringClimate)

# Test a linear functions

OffspringWin_lin <- slidingwin(xvar = list(Temp = OffspringClimate$Temperature), 
                              cdate = OffspringClimate$Date, 
                              bdate = Offspring$Date, 
                              baseline = glm(Offspring ~ 1, data = Offspring, family = poisson),
                              range = c(150, 0), 
                              type = "relative", stat = "mean", 
                              func = c("lin"), cmissing = FALSE, cinterval = "day")

# Test a quadratic functions

OffspringWin_quad <- slidingwin(xvar = list(Temp = OffspringClimate$Temperature), 
                               cdate = OffspringClimate$Date, 
                               bdate = Offspring$Date, 
                               baseline = glm(Offspring ~ 1, data = Offspring, family = poisson),
                               range = c(150, 0), 
                               type = "relative", stat = "mean", 
                               func = c("quad"), cmissing = FALSE, cinterval = "day")
                               
# Combine these outputs

OffspringWin_comb <- merge_results(dataset1 = OffspringWin_lin, dataset2 = OffspringWin_quad)

#View analyses contained in the new output

OffspringWin_comb$combos

#View output from linear analysis

head(OffspringWin_comb[[1]]$Dataset)

}
       
}
\author{
Liam D. Bailey and Martijn van de Pol
}
