% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_1cmt_bolus.R
\name{pk_1cmt_bolus}
\alias{pk_1cmt_bolus}
\title{Concentration predictions for 1-compartmental PK model after single or multiple bolus doses}
\usage{
pk_1cmt_bolus(t = c(0:24), dose = 100, tau = 12, CL = 3, V = 30, ruv = NULL)
}
\arguments{
\item{t}{vector of time}

\item{dose}{dose}

\item{tau}{dosing interval}

\item{CL}{clearance}

\item{V}{volume of distribution}

\item{ruv}{residual error (list)}
}
\description{
Concentration predictions for 1-compartmental PK model after single or multiple bolus doses
}
\examples{
pk_1cmt_bolus(dose = 500, tau = 12, CL = 5, V = 50)
pk_1cmt_bolus(dose = 500, tau = 12, CL = 5, V = 50, t = 24)
pk_1cmt_bolus(
  dose = 500, tau = 12, CL = 5, V = 50,
  ruv = list(prop = 0.1, add = 0.1))
}
