% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{simpleCap}
\alias{simpleCap}
\title{Capitalize the first letter of a word/sentence.}
\usage{
simpleCap(x, onlyFirst = TRUE, rev = FALSE)
}
\arguments{
\item{x}{Character vector to capitalize}

\item{onlyFirst}{Logical, if TRUE (by default)
capitalize the first letter of the first word only.
Otherwise, capitalize the first letters of all words of the sentence.
See also \code{link[tools]{toTitleCase}} for a more syntax-friendly implementation.}

\item{rev}{Logical, if TRUE (FALSE by default), set first letter to lower case (otherwise upper case)}
}
\value{
Character vector with first letter capitalized
}
\description{
This implementation is inspired from the help of the \code{toupper} function.
}
\examples{
# capitalize only the first word of the sentence
simpleCap(x = "this is the caption of my figure.")
# capitalize all words
simpleCap(x = "this is the caption of my figure.", onlyFirst = FALSE)
# opposite: set the first letter of the first word to lower case
simpleCap(x = "This is the caption of my figure.", rev = TRUE)
}
\seealso{
\code{link[tools]{toTitleCase}}
}
\author{
author of the 'toupper' function?
}
