% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcs_plot.r
\name{rcs_plot}
\alias{rcs_plot}
\title{Plot restricted cubic spline}
\usage{
rcs_plot(
  data,
  x,
  y,
  time = NULL,
  covars = NULL,
  knot = 4,
  add_hist = TRUE,
  ref = "x_median",
  ref_digits = 3,
  group_by_ref = TRUE,
  group_title = NULL,
  group_labels = NULL,
  group_colors = NULL,
  breaks = 20,
  rcs_color = "#e23e57",
  print_p_ph = TRUE,
  trans = "identity",
  save_plot = FALSE,
  filename = NULL,
  y_lim = NULL,
  hist_max = NULL,
  xlim = NULL,
  height = 6,
  width = 6,
  return_details = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string of the predictor variable.}

\item{y}{A character string of the outcome variable.}

\item{time}{A character string of the time variable. If \code{NULL}, logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{covars}{A character vector of covariate names.}

\item{knot}{The number of knots. If \code{NULL}, the number of knots is determined by AIC minimum.}

\item{add_hist}{A logical value. If \code{TRUE}, add histogram to the plot.}

\item{ref}{The reference value for the plot. Could be \code{"x_median"}, \code{"x_mean"}, \code{"ratio_min"}, or a numeric value.
If \code{"x_median"}, the median of the predictor variable is used. If \code{"ratio_min"}, the value of the
predictor variable that has the minium predicted risk is used. If a numeric value, that value is used.}

\item{ref_digits}{The number of digits for the reference value.}

\item{group_by_ref}{A logical value. If \code{TRUE}, split the histogram at the reference value from \code{ref} into
two groups.}

\item{group_title}{A character string of the title for the group. Ignored if \code{group_by_ref} is \code{FALSE}.}

\item{group_labels}{A character vector of the labels for the group. If \code{NULL}, the labels are generated
automatically. Ignored if \code{group_by_ref} is \code{FALSE}.}

\item{group_colors}{A character vector of colors for the plot. If \code{NULL}, the default colors are used.
If \code{group_by_ref} is \code{FALSE}, the first color is used as fill color.}

\item{breaks}{The number of breaks for the histogram.}

\item{rcs_color}{The color for the restricted cubic spline.}

\item{print_p_ph}{A logical value. If \code{TRUE}, print the p-value of the proportional hazards test
(\code{survival::cox.zph()}) in the plot.}

\item{trans}{The transformation for the y axis in the plot.
Passed to \code{ggplot2::scale_y_continuous(transform = trans)}.}

\item{save_plot}{A logical value indicating whether to save the plot.}

\item{filename}{A character string specifying the filename for the plot. If \code{NULL}, a default filename is used.}

\item{y_lim}{The range of effect value of the plot. If \code{NULL}, the numbers are determined automatically.}

\item{hist_max}{The maximum value for the histogram. If \code{NULL}, the maximum value is determined automatically.}

\item{xlim}{The x-axis limits for the plot. If \code{NULL}, the limits are the \code{0.025} and \code{0.975} quantiles.
The actual plot range might be slightly larger than this range to fit the histogram.}

\item{height}{The height of the saved plot.}

\item{width}{The width of the saved plot.}

\item{return_details}{A logical value indicating whether to return the details of the plot.}
}
\value{
A \code{ggplot} object, or a list containing the \code{ggplot} object and other details if \code{return_details} is \code{TRUE}.
}
\description{
Plot restricted cubic spline based on package \code{rms}. Support both logistic and cox model.
}
\examples{
data(cancer, package = "survival")
# coxph model with time assigned
rcs_plot(cancer, x = "age", y = "status", time = "time", covars = "ph.karno", save_plot = FALSE)

# logistic model with time not assigned
cancer$dead <- cancer$status == 2
rcs_plot(cancer, x = "age", y = "dead", covars = "ph.karno", save_plot = FALSE)
}
