% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{data}
\name{anClique}
\alias{anClique}
\alias{anClique-class}
\title{'anClique-class' for annotating isotopes and adducts}
\format{An object of class \code{anClique} of length 7.}
\usage{
anClique
}
\description{
S3 Class \code{anClique-class} for annotating isotopes and adducts
in processed m/z data. Features are first
grouped based on a similarity network algorithm and then
annotation of isotopes and adducts is performed in each group.
}
\details{
anClique-class contains the following elements:

'peaklist'
Is a data.frame with m/z, retention time
and intensity information for each feature. It also contains
adduct and isotope information if annotation has been performed.

'network'
Is an igraph undirected network of similarity 
used to compute groups of features before annotation.

'cliques'
Is a list that contains the groups of features.
Each id corresponds to a row in the peaklist.

'isotopes'
Is a data.frame with the column 'feature' for feature id, 
column 'charge' for the charge, column 'grade' that starts with 0
and it is 1 for the first isotope, 2 for the second and so on and
column 'cluster' which labels each group of features that are
isotopes.

'cliquesFound' is
TRUE if clique groups have been computed,
'isoFound' is
TRUE if isotopes have been annotated,
'anFound' is
TRUE if annotation of adducts have been computed.
}
\seealso{
\code{\link{anClique}}
}
\keyword{datasets}
