% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive-time.R
\name{as_naive_time}
\alias{as_naive_time}
\title{Convert to a naive-time}
\usage{
as_naive_time(x)
}
\arguments{
\item{x}{\verb{[object]}

An object to convert to a naive-time.}
}
\value{
A naive-time vector.
}
\description{
\code{as_naive_time()} converts \code{x} to a naive-time.

You can convert to a naive-time from any calendar type, as long as it has
at least day precision. There also must not be any invalid dates. If invalid
dates exist, they must first be resolved with \code{\link[=invalid_resolve]{invalid_resolve()}}.

Converting to a naive-time from a sys-time or zoned-time retains the printed
time, but drops the assumption that the time should be interpreted with any
specific time zone.

Converting to a naive-time from a duration just wraps the duration in a
naive-time object, there is no assumption about the time zone. The duration
must have at least day precision.

There are convenience methods for converting to a naive-time from R's
native date and date-time types. Like converting from a zoned-time, these
retain the printed time.
}
\examples{
x <- as.Date("2019-01-01")
as_naive_time(x)

ym <- year_month_day(2019, 02)

# A minimum of day precision is required
try(as_naive_time(ym))

ymd <- set_day(ym, 10)
as_naive_time(ymd)
}
