% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl}
\alias{cl}
\title{Composite Likelihood Calculation for Spatial Ordinal Data without Replications (for implmentation)}
\usage{
cl(theta, y, X, dwdv, cmwdv, lt, wn, base, J, p)
}
\arguments{
\item{theta}{a vector of parameter value.}

\item{y}{a vector of observation for the subject.}

\item{X}{covariate for the particular subject.}

\item{dwdv}{corresponding distance of selected pair.}

\item{cmwdv}{combination of the pairs included into the composite likelihood.}

\item{lt}{number of parameter (i.e. length of theta).}

\item{wn}{number of pairs with distance.}

\item{base}{identity matrix with dimension \code{J+1}.}

\item{J}{number of category among (ALL) observed response.}

\item{p}{number of covariate (i.e. number of column of \code{X}).}
}
\value{
\code{cl} returns a list: composite log-likelihood value and a vector of first-order partial derivatives for \code{theta}.
}
\description{
\code{cl} Calculate the  composite log-likelihood value and score function for a particular subject given parameter value and other input variables.
}
