/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nbl.utilj.SysProp;
import ppe.StateChangeListener;
import ppe.UtilPPE;
import ppe.ec2.Constants;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.InstanceStatus;
import ppe.ec2.InstanceTag;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NoSuchNetworkException;

public class NiM {
    private static NiM nim;
    private HashMap<String, NetworkInfo> htByName;
    private HashMap<String, NetworkInfo> htByID;
    private List<NetworkInfo> list;
    private List<StateChangeListener> stateChangeListeners = new ArrayList<StateChangeListener>();

    public static void init() {
        nim = new NiM();
    }

    public static boolean register(NetworkInfo ni) {
        return nim.registerNi(ni);
    }

    public static void update(Ec2Wrangler ec2w) {
        NiM.update(ec2w.getInstancesAllListed());
    }

    public static void update(List<InstanceStatus> instances) {
        nim.findNetworks(instances);
    }

    public static NetworkInfo getForID(String networkID) {
        return NiM.nim.htByID.get(networkID);
    }

    public static NetworkInfo getForIDWhenAvailable(String networkID, long maxWait) throws NoSuchNetworkException {
        long tm0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - tm0 <= maxWait) {
            NetworkInfo ni = NiM.nim.htByID.get(networkID);
            if (ni != null) {
                return ni;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        throw new NoSuchNetworkException("No network found with ID=" + networkID);
    }

    public static NetworkInfo getForName(String networkName) {
        return NiM.nim.htByName.get(networkName);
    }

    public static NetworkInfo getForMasterHostname(String hostName) {
        for (NetworkInfo ni : NiM.nim.list) {
            if (!ni.getMastersPublicDnsName().equals(hostName)) continue;
            return ni;
        }
        return null;
    }

    public static List<NetworkInfo> getNetworks() {
        return NiM.nim.list;
    }

    public static boolean IDExists(String ID) {
        if (NiM.nim.htByID == null) {
            return false;
        }
        return NiM.nim.htByID.containsKey(ID);
    }

    public static boolean nameExists(String name) {
        if (NiM.nim.htByName == null) {
            return false;
        }
        return NiM.nim.htByName.containsKey(name);
    }

    public static String createNetworkID() {
        while (true) {
            long time = System.currentTimeMillis();
            String ID = Constants.NETWORD_ID_PREFIX + Long.toString(UtilPPE.toYMDHMSM(time));
            if (!NiM.IDExists(ID)) {
                return ID;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static String createUniqueDefaultNetworkName() {
        String name = SysProp.user_name.getVal() + "-" + Integer.toString(UtilPPE.toYMD(System.currentTimeMillis()));
        if (!NiM.nameExists(name)) {
            return name;
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String nm = name + "_" + Integer.toString(i);
            if (NiM.nameExists(nm)) continue;
            return nm;
        }
        throw new RuntimeException("Failed to create a unique default network name.");
    }

    public static String summarize() {
        StringBuilder s = new StringBuilder();
        List<NetworkInfo> nis = NiM.getNetworks();
        s.append("N networks=" + nis.size() + "\n");
        for (NetworkInfo ni : nis) {
            s.append("  " + ni.toString() + "\n");
            for (InstanceStatus ins : ni.instances) {
                s.append("     " + ins.getPublicDnsName() + " " + ins.instance.getState().getName() + " " + ins.getTagValue(InstanceTag.nodeType) + "\n");
            }
        }
        return s.toString();
    }

    public static void addStateChangeListener(StateChangeListener listener) {
        if (!NiM.nim.stateChangeListeners.contains(listener)) {
            NiM.nim.stateChangeListeners.add(listener);
        }
    }

    public static void fireStateChangeEvent() {
        for (int i = 0; i < NiM.nim.stateChangeListeners.size(); ++i) {
            NiM.nim.stateChangeListeners.get(i).stateChanged();
        }
    }

    public static boolean networkRunning() {
        return nim.hasRunningNetwork();
    }

    private NiM() {
        this.htByName = new HashMap();
        this.htByID = new HashMap();
        this.list = new ArrayList<NetworkInfo>();
    }

    private boolean registerNi(NetworkInfo ni) {
        String ID = ni.getNetworkID();
        if (ID == null) {
            return false;
        }
        if (this.htByID.containsKey(ID)) {
            String name = ni.getNetworkName();
            if (name != null && !this.htByName.containsKey(name)) {
                this.htByName.put(name, ni);
            }
            return false;
        }
        this.list.add(ni);
        this.htByID.put(ID, ni);
        String name = ni.getNetworkName();
        if (name != null) {
            this.htByName.put(name, ni);
        }
        return true;
    }

    private void findNetworks(List<InstanceStatus> instances) {
        for (NetworkInfo ni : this.list) {
            ni.clearInstances();
        }
        for (InstanceStatus s : instances) {
            String ID = s.getNetworkID();
            String name = s.getNetworkName();
            if (ID == null || name == null) continue;
            NetworkInfo ni = this.htByID.get(ID);
            if (ni == null) {
                ni = new NetworkInfo(ID, name);
                ni.setEndogeous(false);
                NiM.register(ni);
            }
            ni.add(s);
        }
        Collections.sort(this.list);
        for (NetworkInfo ni : this.list) {
            ni.setState();
        }
        NiM.fireStateChangeEvent();
    }

    boolean hasRunningNetwork() {
        if (this.list.size() < 1) {
            return false;
        }
        for (NetworkInfo ni : this.list) {
            if (!ni.isRunning()) continue;
            return true;
        }
        return false;
    }
}

