/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nbl.utilj.SysProp;
import ppe.ParamMissingException;
import ppe.ec2.Constants;
import ppe.ec2.InstanceStatus;
import ppe.ec2.NetworkInfo;
import ppe.ec2.ParamsEc2;

public class SecurityGroupFactory {
    AmazonEC2Client ec2Client;
    ParamsEc2 params;

    public SecurityGroupFactory(ParamsEc2 params, AmazonEC2Client ec2Client) {
        this.params = params;
        this.ec2Client = ec2Client;
    }

    public String createOneTimeSecurityGroup() throws ParamMissingException {
        return this.createStandardSecurityGroup(this.createUniqueSecurityGroupName(), Constants.SECURITY_GROUP_DES);
    }

    public String createStandardSecurityGroup(String groupName, String description) throws ParamMissingException {
        CreateSecurityGroupRequest req = new CreateSecurityGroupRequest(groupName, description);
        this.ec2Client.createSecurityGroup(req);
        AuthorizeSecurityGroupIngressRequest aReq = new AuthorizeSecurityGroupIngressRequest();
        aReq.setGroupName(groupName);
        aReq.setIpPermissions(this.createMpiIpPermissions(groupName));
        this.ec2Client.authorizeSecurityGroupIngress(aReq);
        return groupName;
    }

    public String getOneTimeSecurityGroupName() throws ParamMissingException {
        DescribeSecurityGroupsResult sgr = this.ec2Client.describeSecurityGroups();
        for (SecurityGroup sg : sgr.getSecurityGroups()) {
            if (!sg.getGroupName().startsWith(this.buildSecurityGroupNamePrefix())) continue;
            return sg.getGroupName();
        }
        return null;
    }

    public int deleteOneTimeSecurityGroups() throws ParamMissingException {
        DescribeSecurityGroupsResult sgr = this.ec2Client.describeSecurityGroups();
        int nDeleted = 0;
        String prefix = this.buildSecurityGroupNamePrefix();
        for (SecurityGroup sg : sgr.getSecurityGroups()) {
            if (!sg.getGroupName().startsWith(prefix)) continue;
            DeleteSecurityGroupRequest dr = new DeleteSecurityGroupRequest(sg.getGroupName());
            this.ec2Client.deleteSecurityGroup(dr);
            ++nDeleted;
        }
        return nDeleted;
    }

    public List<SecurityGroup> getExtantSecurityGroups() {
        return this.ec2Client.describeSecurityGroups().getSecurityGroups();
    }

    public void deleteOneTimeSecurityGroup(String securityGroupName) {
        if (!securityGroupName.startsWith(this.buildSecurityGroupNamePrefix())) {
            return;
        }
        DeleteSecurityGroupRequest dr = new DeleteSecurityGroupRequest(securityGroupName);
        this.ec2Client.deleteSecurityGroup(dr);
    }

    public List<String> getSecurityGroups(NetworkInfo ni) {
        HashMap<String, String> sgHt = new HashMap<String, String>();
        DescribeInstancesResult ir = this.ec2Client.describeInstances();
        block0: for (Reservation r : ir.getReservations()) {
            List sgs = r.getGroupNames();
            List insL = r.getInstances();
            for (Instance ins : insL) {
                InstanceStatus x = new InstanceStatus(ins, sgs);
                if (!x.hasNetworkID(ni.ID)) continue;
                for (String sg : sgs) {
                    sgHt.put(sg, sg);
                }
                continue block0;
            }
        }
        ArrayList<String> usgs = new ArrayList<String>();
        Iterator it = sgHt.keySet().iterator();
        while (it.hasNext()) {
            usgs.add((String)it.next());
        }
        return usgs;
    }

    public List<String> getOneTimeSecurityGroups(NetworkInfo ni) {
        String prefix = this.buildSecurityGroupNamePrefix();
        List<String> sgs = this.getSecurityGroups(ni);
        ArrayList<String> ots = new ArrayList<String>();
        for (String s : sgs) {
            if (!s.startsWith(prefix)) continue;
            ots.add(s);
        }
        return ots;
    }

    private String buildSecurityGroupNamePrefix() {
        return SysProp.user_name.getVal() + "_mpi_ec2_";
    }

    private String createUniqueSecurityGroupName() {
        HashMap<String, SecurityGroup> ht = this.getExtantSecurityGroupHt();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String nm = this.buildSecurityGroupNamePrefix() + Integer.toString(i);
            if (ht.containsKey(nm)) continue;
            return nm;
        }
        throw new RuntimeException("Failed to create a unique security group name with prefix " + this.buildSecurityGroupNamePrefix());
    }

    private HashMap<String, SecurityGroup> getExtantSecurityGroupHt() {
        DescribeSecurityGroupsResult r = this.ec2Client.describeSecurityGroups();
        HashMap<String, SecurityGroup> ht = new HashMap<String, SecurityGroup>();
        for (SecurityGroup sg : r.getSecurityGroups()) {
            ht.put(sg.getGroupName(), sg);
        }
        return ht;
    }

    private List<IpPermission> createMpiIpPermissions(String securityGroupName) {
        ArrayList<IpPermission> ipps = new ArrayList<IpPermission>();
        ipps.add(this.createIPPermissionIP("tcp", 22, 22, "0.0.0.0/0"));
        ipps.add(this.createIPPermissionGroup("icmp", -1, -1, securityGroupName));
        ipps.add(this.createIPPermissionGroup("tcp", 23, 65535, securityGroupName));
        ipps.add(this.createIPPermissionGroup("tcp", 1, 21, securityGroupName));
        ipps.add(this.createIPPermissionGroup("udp", 1, 65535, securityGroupName));
        return ipps;
    }

    private IpPermission createIPPermissionIP(String protocol, int fromPort, int toPort, String ip) {
        IpPermission ipp = new IpPermission();
        ipp.setIpProtocol(protocol);
        ipp.setFromPort(Integer.valueOf(fromPort));
        ipp.setToPort(Integer.valueOf(toPort));
        ArrayList<String> ips = new ArrayList<String>();
        ips.add(ip);
        ipp.setIpRanges(ips);
        return ipp;
    }

    private IpPermission createIPPermissionGroup(String protocol, int fromPort, int toPort, String group) {
        IpPermission ipp = new IpPermission();
        ipp.setIpProtocol(protocol);
        ipp.setFromPort(Integer.valueOf(fromPort));
        ipp.setToPort(Integer.valueOf(toPort));
        ArrayList<UserIdGroupPair> gps = new ArrayList<UserIdGroupPair>();
        UserIdGroupPair gp = new UserIdGroupPair();
        gp.setGroupName(group);
        gp.setUserId(this.params.getAWSUserID());
        gps.add(gp);
        ipp.setUserIdGroupPairs(gps);
        return ipp;
    }
}

