/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.ompi;

import ch.ethz.ssh2.Connection;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.Services;
import com.norbl.cbp.ppe.ompi.ConstantsOmpi;
import com.norbl.cbp.ppe.ompi.OmpiConfig;
import com.norbl.util.ssh.ConstantsSSH;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshExec;

public class OmpiConfigServices
extends Services {
    private static final long TEST_INTERVAL = 15000L;
    private static final long MAX_TEST_AGE = 300000L;
    private State state;
    OmpiConfig oc;
    private long initialTestTime;
    private long lastTestTime;
    private Ec2Wrangler ec2w;
    private NetworkSpec networkSpec;
    private ParamsEc2 paramsEc2;

    public OmpiConfigServices(String networkID) {
        super(networkID);
        this.setState(State.nil);
        this.oc = null;
        this.initialTestTime = -1L;
        this.lastTestTime = -1L;
    }

    public void set(Ec2Wrangler ec2w) {
        this.ec2w = ec2w;
    }

    public void set(NetworkSpec networkSpec) {
        this.networkSpec = networkSpec;
    }

    public void set(ParamsEc2 paramsEc2) {
        this.paramsEc2 = paramsEc2;
    }

    private synchronized void setState(State state) {
        this.state = state;
        NiM.fireStateChangeEvent();
    }

    @Override
    public boolean isRunning() {
        this.findState();
        return State.running.equals((Object)this.state);
    }

    @Override
    public boolean isPending() {
        this.findState();
        return State.pending.equals((Object)this.state);
    }

    @Override
    public boolean notRunning() {
        this.findState();
        return State.notRunning.equals((Object)this.state);
    }

    @Override
    public boolean inNilState() {
        this.findState();
        return State.nil.equals((Object)this.state);
    }

    private void findState() {
        if (!State.nil.equals((Object)this.state)) {
            return;
        }
        if (this.oc == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OmpiConfigServices.this.checkConfiguration();
            }
        }).start();
    }

    @Override
    public String getStateTitle() {
        this.findState();
        switch (this.state) {
            case nil: {
                return "determining ompi state";
            }
            case running: {
                return "ompi configured";
            }
            case notRunning: {
                return "ompi not configured";
            }
            case pending: {
                if (this.oc != null) {
                    return this.oc.getStateDescription();
                }
                throw new RuntimeException("OmpiConfigServices state == pending but OmpiConfi == null");
            }
        }
        return "-";
    }

    @Override
    public void launch() {
        this.setState(State.pending);
        this.oc = new OmpiConfig(this.ec2w, this.networkSpec, this.paramsEc2);
        if (this.oc.config(this.networkID)) {
            this.setState(State.running);
        } else {
            this.setState(State.notRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkConfiguration() {
        Connection con = null;
        try {
            boolean boo;
            NetworkInfo ni = NiM.getForID(this.networkID);
            if (ni == null) {
                return;
            }
            con = Ssh.connect(ni.getMastersPublicDnsName(), ConstantsEc2.EC2_USERNAME, PPEManager.paramsEc2.rsaKeyPairFile, (long)ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS);
            SshExec sx = new SshExec(con);
            boolean bl = boo = sx.fileExists(ConstantsEc2.EC2_USER_HOME_DIR + "/" + ConstantsOmpi.OMPI_HOSTFILE_NAME) && sx.fileExists(ConstantsEc2.EC2_USER_SSH_DIR + "/" + ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME);
            if (boo) {
                this.setState(State.running);
            } else {
                this.setState(State.notRunning);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private static enum State {
        nil,
        pending,
        running,
        notRunning;

    }
}

