/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStreamingDistributionRequestMarshaller
implements Marshaller<Request<CreateStreamingDistributionRequest>, CreateStreamingDistributionRequest> {
    @Override
    public Request<CreateStreamingDistributionRequest> marshall(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        StreamingDistributionConfig streamingDistributionConfigStreamingDistributionConfig;
        if (createStreamingDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStreamingDistributionRequest> request = new DefaultRequest<CreateStreamingDistributionRequest>(createStreamingDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2010-11-01/streaming-distribution";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("&")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2010-11-01/");
        if (createStreamingDistributionRequest != null && (streamingDistributionConfigStreamingDistributionConfig = createStreamingDistributionRequest.getStreamingDistributionConfig()) != null) {
            TrustedSigners trustedSignersTrustedSigners;
            LoggingConfig loggingConfigLogging;
            List<String> cNAMEList;
            S3Origin s3OriginS3Origin;
            xmlWriter.startElement("StreamingDistributionConfig");
            if (streamingDistributionConfigStreamingDistributionConfig != null && (s3OriginS3Origin = streamingDistributionConfigStreamingDistributionConfig.getS3Origin()) != null) {
                xmlWriter.startElement("S3Origin");
                if (s3OriginS3Origin.getDNSName() != null) {
                    xmlWriter.startElement("DNSName").value(s3OriginS3Origin.getDNSName()).endElement();
                }
                if (s3OriginS3Origin.getOriginAccessIdentity() != null) {
                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginS3Origin.getOriginAccessIdentity()).endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(streamingDistributionConfigStreamingDistributionConfig.getCallerReference()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (cNAMEList = streamingDistributionConfigStreamingDistributionConfig.getCNAME()) != null && cNAMEList.size() > 0) {
                int cNAMEListIndex = 1;
                for (String cNAMEListValue : cNAMEList) {
                    xmlWriter.startElement("CNAME");
                    xmlWriter.value(cNAMEListValue);
                    xmlWriter.endElement();
                    ++cNAMEListIndex;
                }
            }
            if (streamingDistributionConfigStreamingDistributionConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(streamingDistributionConfigStreamingDistributionConfig.getComment()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig.isEnabled() != null) {
                xmlWriter.startElement("Enabled").value(streamingDistributionConfigStreamingDistributionConfig.isEnabled()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (loggingConfigLogging = streamingDistributionConfigStreamingDistributionConfig.getLogging()) != null) {
                xmlWriter.startElement("Logging");
                if (loggingConfigLogging.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(loggingConfigLogging.getBucket()).endElement();
                }
                if (loggingConfigLogging.getPrefix() != null) {
                    xmlWriter.startElement("Prefix").value(loggingConfigLogging.getPrefix()).endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (trustedSignersTrustedSigners = streamingDistributionConfigStreamingDistributionConfig.getTrustedSigners()) != null) {
                List<String> awsAccountNumbersList;
                xmlWriter.startElement("TrustedSigners");
                if (trustedSignersTrustedSigners.getSelf() != null) {
                    xmlWriter.startElement("Self").value(trustedSignersTrustedSigners.getSelf()).endElement();
                }
                if (trustedSignersTrustedSigners != null && (awsAccountNumbersList = trustedSignersTrustedSigners.getAwsAccountNumbers()) != null && awsAccountNumbersList.size() > 0) {
                    int awsAccountNumbersListIndex = 1;
                    for (String awsAccountNumbersListValue : awsAccountNumbersList) {
                        xmlWriter.startElement("AwsAccountNumber");
                        xmlWriter.value(awsAccountNumbersListValue);
                        xmlWriter.endElement();
                        ++awsAccountNumbersListIndex;
                    }
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

