/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTerminationProtectionRequestMarshaller
implements Marshaller<Request<SetTerminationProtectionRequest>, SetTerminationProtectionRequest> {
    @Override
    public Request<SetTerminationProtectionRequest> marshall(SetTerminationProtectionRequest setTerminationProtectionRequest) {
        if (setTerminationProtectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetTerminationProtectionRequest> request = new DefaultRequest<SetTerminationProtectionRequest>(setTerminationProtectionRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "SetTerminationProtection");
        request.addParameter("Version", "2009-03-31");
        List<String> jobFlowIdsList = setTerminationProtectionRequest.getJobFlowIds();
        int jobFlowIdsListIndex = 1;
        for (String jobFlowIdsListValue : jobFlowIdsList) {
            if (jobFlowIdsListValue != null) {
                request.addParameter("JobFlowIds.member." + jobFlowIdsListIndex, StringUtils.fromString(jobFlowIdsListValue));
            }
            ++jobFlowIdsListIndex;
        }
        if (setTerminationProtectionRequest.isTerminationProtected() != null) {
            request.addParameter("TerminationProtected", StringUtils.fromBoolean(setTerminationProtectionRequest.isTerminationProtected()));
        }
        return request;
    }
}

