/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeEnvironmentsRequest
extends AmazonWebServiceRequest {
    private String applicationName;
    private String versionLabel;
    private List<String> environmentIds;
    private List<String> environmentNames;
    private Boolean includeDeleted;
    private Date includedDeletedBackTo;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public DescribeEnvironmentsRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public DescribeEnvironmentsRequest withVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
        return this;
    }

    public List<String> getEnvironmentIds() {
        if (this.environmentIds == null) {
            this.environmentIds = new ArrayList<String>();
        }
        return this.environmentIds;
    }

    public void setEnvironmentIds(Collection<String> environmentIds) {
        if (environmentIds == null) {
            this.environmentIds = null;
            return;
        }
        ArrayList<String> environmentIdsCopy = new ArrayList<String>(environmentIds.size());
        environmentIdsCopy.addAll(environmentIds);
        this.environmentIds = environmentIdsCopy;
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(String ... environmentIds) {
        if (this.getEnvironmentIds() == null) {
            this.setEnvironmentIds(new ArrayList<String>(environmentIds.length));
        }
        for (String value : environmentIds) {
            this.getEnvironmentIds().add(value);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(Collection<String> environmentIds) {
        if (environmentIds == null) {
            this.environmentIds = null;
        } else {
            ArrayList<String> environmentIdsCopy = new ArrayList<String>(environmentIds.size());
            environmentIdsCopy.addAll(environmentIds);
            this.environmentIds = environmentIdsCopy;
        }
        return this;
    }

    public List<String> getEnvironmentNames() {
        if (this.environmentNames == null) {
            this.environmentNames = new ArrayList<String>();
        }
        return this.environmentNames;
    }

    public void setEnvironmentNames(Collection<String> environmentNames) {
        if (environmentNames == null) {
            this.environmentNames = null;
            return;
        }
        ArrayList<String> environmentNamesCopy = new ArrayList<String>(environmentNames.size());
        environmentNamesCopy.addAll(environmentNames);
        this.environmentNames = environmentNamesCopy;
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(String ... environmentNames) {
        if (this.getEnvironmentNames() == null) {
            this.setEnvironmentNames(new ArrayList<String>(environmentNames.length));
        }
        for (String value : environmentNames) {
            this.getEnvironmentNames().add(value);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(Collection<String> environmentNames) {
        if (environmentNames == null) {
            this.environmentNames = null;
        } else {
            ArrayList<String> environmentNamesCopy = new ArrayList<String>(environmentNames.size());
            environmentNamesCopy.addAll(environmentNames);
            this.environmentNames = environmentNamesCopy;
        }
        return this;
    }

    public Boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public DescribeEnvironmentsRequest withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public Date getIncludedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public void setIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.includedDeletedBackTo = includedDeletedBackTo;
    }

    public DescribeEnvironmentsRequest withIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.includedDeletedBackTo = includedDeletedBackTo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName != null) {
            sb.append("ApplicationName: " + this.applicationName + ", ");
        }
        if (this.versionLabel != null) {
            sb.append("VersionLabel: " + this.versionLabel + ", ");
        }
        if (this.environmentIds != null) {
            sb.append("EnvironmentIds: " + this.environmentIds + ", ");
        }
        if (this.environmentNames != null) {
            sb.append("EnvironmentNames: " + this.environmentNames + ", ");
        }
        if (this.includeDeleted != null) {
            sb.append("IncludeDeleted: " + this.includeDeleted + ", ");
        }
        if (this.includedDeletedBackTo != null) {
            sb.append("IncludedDeletedBackTo: " + this.includedDeletedBackTo + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentIds() == null ? 0 : ((Object)this.getEnvironmentIds()).hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentNames() == null ? 0 : ((Object)this.getEnvironmentNames()).hashCode());
        hashCode = 31 * hashCode + (this.isIncludeDeleted() == null ? 0 : this.isIncludeDeleted().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedDeletedBackTo() == null ? 0 : this.getIncludedDeletedBackTo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getEnvironmentIds() == null ^ this.getEnvironmentIds() == null) {
            return false;
        }
        if (other.getEnvironmentIds() != null && !((Object)other.getEnvironmentIds()).equals(this.getEnvironmentIds())) {
            return false;
        }
        if (other.getEnvironmentNames() == null ^ this.getEnvironmentNames() == null) {
            return false;
        }
        if (other.getEnvironmentNames() != null && !((Object)other.getEnvironmentNames()).equals(this.getEnvironmentNames())) {
            return false;
        }
        if (other.isIncludeDeleted() == null ^ this.isIncludeDeleted() == null) {
            return false;
        }
        if (other.isIncludeDeleted() != null && !other.isIncludeDeleted().equals(this.isIncludeDeleted())) {
            return false;
        }
        if (other.getIncludedDeletedBackTo() == null ^ this.getIncludedDeletedBackTo() == null) {
            return false;
        }
        return other.getIncludedDeletedBackTo() == null || other.getIncludedDeletedBackTo().equals(this.getIncludedDeletedBackTo());
    }
}

