/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.generic;

import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkflowExecutionParameters {
    private String workflowId;
    private WorkflowType workflowType;
    private String taskList;
    private String input;
    private long executionStartToCloseTimeoutSeconds = -2L;
    private long taskStartToCloseTimeoutSeconds = -2L;
    private List<String> tagList;

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public StartWorkflowExecutionParameters withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public StartWorkflowExecutionParameters withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public StartWorkflowExecutionParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public StartWorkflowExecutionParameters withInput(String input) {
        this.input = input;
        return this;
    }

    public long getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public void setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        return this;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public void setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        return this;
    }

    public List<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new ArrayList<String>();
        }
        return this.tagList;
    }

    public void setTagList(Collection<String> tagList) {
        ArrayList<String> tagListCopy = new ArrayList<String>();
        if (tagList != null) {
            tagListCopy.addAll(tagList);
        }
        this.tagList = tagListCopy;
    }

    public StartWorkflowExecutionParameters withTagList(String ... tagList) {
        for (String value : tagList) {
            this.getTagList().add(value);
        }
        return this;
    }

    public StartWorkflowExecutionParameters withTagList(Collection<String> tagList) {
        ArrayList<String> tagListCopy = new ArrayList<String>();
        if (tagList != null) {
            tagListCopy.addAll(tagList);
        }
        this.tagList = tagListCopy;
        return this;
    }

    public StartWorkflowExecutionParameters createStartWorkflowExecutionParametersFromOptions(StartWorkflowOptions options, StartWorkflowOptions optionsOverride) {
        String taskList;
        List<String> tagList;
        Long taskStartToCloseTimeout;
        Long executionStartToCloseTimeout;
        StartWorkflowExecutionParameters parameters = this.clone();
        if (options != null) {
            executionStartToCloseTimeout = options.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeout != null) {
                parameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeout);
            }
            if ((taskStartToCloseTimeout = options.getTaskStartToCloseTimeoutSeconds()) != null) {
                parameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeout);
            }
            if ((tagList = options.getTagList()) != null) {
                parameters.setTagList(tagList);
            }
            if ((taskList = options.getTaskList()) != null && !taskList.isEmpty()) {
                parameters.setTaskList(taskList);
            }
        }
        if (optionsOverride != null) {
            executionStartToCloseTimeout = optionsOverride.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeout != null) {
                parameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeout);
            }
            if ((taskStartToCloseTimeout = optionsOverride.getTaskStartToCloseTimeoutSeconds()) != null) {
                parameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeout);
            }
            if ((tagList = optionsOverride.getTagList()) != null) {
                parameters.setTagList(tagList);
            }
            if ((taskList = optionsOverride.getTaskList()) != null && !taskList.isEmpty()) {
                parameters.setTaskList(taskList);
            }
        }
        return parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("WorkflowId: " + this.workflowId + ", ");
        sb.append("WorkflowType: " + this.workflowType + ", ");
        sb.append("TaskList: " + this.taskList + ", ");
        sb.append("Input: " + this.input + ", ");
        sb.append("StartToCloseTimeout: " + this.executionStartToCloseTimeoutSeconds + ", ");
        sb.append("TagList: " + this.tagList + ", ");
        sb.append("}");
        return sb.toString();
    }

    public StartWorkflowExecutionParameters clone() {
        StartWorkflowExecutionParameters result = new StartWorkflowExecutionParameters();
        result.setInput(this.input);
        result.setExecutionStartToCloseTimeoutSeconds(this.executionStartToCloseTimeoutSeconds);
        result.setTaskStartToCloseTimeoutSeconds(this.taskStartToCloseTimeoutSeconds);
        result.setTagList(this.tagList);
        result.setTaskList(this.taskList);
        result.setWorkflowId(this.workflowId);
        result.setWorkflowType(this.workflowType);
        return result;
    }
}

