% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranksum.R
\name{cluswilcox.test.ranksum}
\alias{cluswilcox.test.ranksum}
\title{Wilcoxon Rank Sum Test for Clustered Data}
\usage{
\method{cluswilcox.test}{ranksum}(x, cluster, group, strats, alternative, mu,
  DNAME = NULL, METHOD = NULL)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{cluster}{a numeric vector indicating the cluster ids of the scores.
If not specified, each score has its own id, i.e., there is no
cluster in the data.}

\item{group}{a numeric vector indicating group id.}

\item{strats}{a numeric vector indicatg the strats ids of
the scores. The default is that the data has no stratum.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of "two.sided" (default),
 "greater" or "less". You can specify just the initial letter.}

\item{mu}{null value of the hypothesis}

\item{DNAME}{a character string, inheritated from
\code{cluswilcox.test.model}, for result output.}

\item{METHOD}{a character string, inheritated from
\code{cluswilcox.test.model}, for result output.}
}
\value{
a list with the following components
\item{rstatistic}{Clustered Wilcoxon ranksum statistic.}
\item{erstatistics}{Expected value clustered Wilcoxon ranksum statistic.}
\item{vrstatistics}{Variance of clustered Wilcoxon ranksum statistic.}
\item{statistics}{the value of the test statistic.}
\item{p.value}{the p-value for the test}
\item{data.name}{a character string giving the names of the data.}
\item{method}{the name of the method}
\item{balance}{a logical, indicating if the data is balanced.}
}
\description{
This is the rank sum test for clustered data.
The cluster size can be either
identitical or variable. Effect of stratification on the test
is also adjusted for if in presence.
}
\examples{
data(crd)
cluswilcox.test(z ~ group(group) + cluster(id), data = crd)
data(crdStr)
cluswilcox.test(z ~ group(group) + cluster(id) + stratum(stratum), data = crdStr)

}
\author{
Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2003)
\emph{Incorporation of Clustering Effects for the Wilcoxon Rank
Sum Test: A Large-Sample Approach.} Biometrics, \bold{59}, 1089-1098.
}

