% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barnacle5.R
\docType{data}
\name{barnacle5}
\alias{barnacle5}
\title{Barnacle data}
\format{\code{barnacle5} is a data frame with 5000 cases (rows) and
3 variables (columns).

Note that \code{barnacle} data set from the \code{npregfast} package
gives the same three variables (columns) but for two sites, thus 2000 cases (rows).
\describe{
 \item{DW}{Dry weight (in g.)}
 \item{RC}{Rostro-carinal lenght (in mm).}
 \item{F}{Factor indicating the sites of harvest: \code{laxe}, \code{lens},
 \code{barca}, \code{laxe}, and \code{lens}.}
 }}
\usage{
barnacle5
}
\description{
This barnacle data set gives the measurements of the variables
dry weight (in g.) and rostro-carinal lenght (in mm) for 5000 barnacles
collected along the intertidal zone from five sites of the Atlantic coast of Galicia (Spain).
}
\examples{
data(barnacle5)
head(barnacle5)



}
\references{
Sestelo, M. and Roca-Pardinas, J. (2011). A new approach to estimation of
length-weight relationship of \eqn{Pollicipes}  \eqn{pollicipes}
(Gmelin, 1789) on the Atlantic coast of Galicia (Northwest Spain): some
aspects of its biology and management. Journal of Shellfish Research,
30(3), 939--948.

Sestelo, M., Villanueva, N.M., Meira-Machado, L., Roca-Pardinas, J. (2017).
npregfast: An R Package for Nonparametric Estimation and Inference in Life
Sciences. Journal of Statistical Software, 82(12), 1-27.
}
\author{
Marta Sestelo
}
