% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterIMmlogit.R
\name{cluster.im.mlogit}
\alias{cluster.im.mlogit}
\title{Cluster-Adjusted Confidence Intervals and p-Values for mlogit}
\usage{
cluster.im.mlogit(mod, dat, cluster, ci.level = 0.95, report = TRUE,
  truncate = FALSE)
}
\arguments{
\item{mod}{A model estimated using \code{mlogit}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{ci.level}{What confidence level should CIs reflect?}

\item{report}{Should a table of results be printed to the console?}

\item{truncate}{Should outlying cluster-specific beta estimates be excluded?}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{ci}{A matrix of confidence intervals.}
}
\description{
Computes p-values and confidence intervals for multinomial logit models based on cluster-specific model estimation (Ibragimov and Muller 2010). A separate model is estimated in each cluster, and then p-values and confidence intervals are computed based on a t/normal distribution of the cluster-specific estimates.
}
\note{
Confidence intervals are centered on the cluster averaged estimate, which can diverge from original model estimates if clusters have different numbers of observations. Consequently, confidence intervals may not be centered on original model estimates.
}
\examples{
\dontrun{
# predict method of hospital admission
require(VGAMdata)
data(vtinpat)

# to save time, take a sample of this data
set.seed(32149)
idx <- sample(1:dim(vtinpat)[1], 5000, replace=F)
vtinpat <- vtinpat[idx,]

vtinpat$hos.num <- as.numeric(vtinpat$hospital)
vtinpat$age <- as.numeric(vtinpat$age.group)
vtinpat.mlogit <- mlogit.data(vtinpat, choice = "admit", shape="wide")
vt.mod <- mlogit(admit ~ 0 | age + sex, data = vtinpat.mlogit)
summary(vt.mod)

# compute cluster-adjusted p-values (takes a while)
clust.p <- cluster.im.mlogit(vt.mod, dat=vtinpat.mlogit, cluster = ~ hos.num,
           ci.level = 0.95, report=TRUE, truncate=TRUE)
}
}
\author{
Justin Esarey
}
\references{
Ibragimov, Rustam, and Ulrich K. Muller. 2010. "t-Statistic Based Correlation and Heterogeneity Robust Inference." \emph{Journal of Business & Economic Statistics} 28(4): 453-468.
}

