% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master.r
\name{master}
\alias{master}
\title{Master controlling the workers}
\usage{
master(fun, iter, const = list(), export = list(), seed = 128965,
  template = list(), n_jobs = NULL, walltime = NA, fail_on_error = TRUE,
  log_worker = FALSE, wait_time = NA, chunk_size = NA)
}
\arguments{
\item{fun}{A function to call}

\item{iter}{Objects to be iterated in each function call}

\item{const}{A list of constant arguments passed to each function call}

\item{export}{List of objects to be exported to the worker}

\item{seed}{A seed to set for each function call}

\item{template}{Named list of values to fill in template}

\item{n_jobs}{The number of LSF jobs to submit}

\item{walltime}{The amount of time a job has to complete; default: no value}

\item{fail_on_error}{If an error occurs on the workers, continue or fail?}

\item{log_worker}{Write a log file for each worker}

\item{wait_time}{Time to wait between messages; set 0 for short calls
defaults to 1/sqrt(number_of_functon_calls)}

\item{chunk_size}{Number of function calls to chunk together
defaults to 100 chunks per worker or max. 500 kb per chunk}
}
\value{
A list of whatever `fun` returned
}
\description{
exchanging messages between the master and workers works the following way:
 * we have submitted a job where we don't know when it will start up
 * it starts, sends is a message list(id=0) indicating it is ready
 * we send it the function definition and common data
   * we also send it the first data set to work on
 * when we get any id > 0, it is a result that we store
   * and send the next data set/index to work on
 * when computatons are complete, we send id=0 to the worker
   * it responds with id=-1 (and usage stats) and shuts down
}
