% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{nba_clusts}
\alias{nba_clusts}
\title{Clustered NBA positions dataset}
\format{
\code{nba_clusts} is a data.frame containing the NBA positions dataset
with additional columns holding k-means clusterings at different values of
\code{k} and the first two principal components
\itemize{
\item \strong{Position} - Player position
\item \strong{TurnoverPct} - Turnover percentage
\item \strong{ReboundPct} - Rebound percentage
\item \strong{AssistPct} - Assist percentage
\item \strong{FieldGoalPct} - Field goal percentage
\item \strong{K1 - K5} - Results of k-means clustering
\item \strong{PC1} - First principal component
\item \strong{PC2} - Second principal component
}
}
\source{
NBA positions downloaded from \url{https://github.com/lazappi/nba_positions}.

The source dataset is available from Kaggle at
\url{https://www.kaggle.com/drgilermo/nba-players-stats/data?select=Seasons_Stats.csv}
and was originally scraped from \href{https://www.basketball-reference.com/}{Basketball Reference}.

See \url{https://github.com/lazappi/clustree/blob/master/data-raw/nba_clusts.R}
for details of how clustering was performed.
}
\usage{
nba_clusts
}
\description{
NBA positions dataset clustered using k-means with a range of values of \code{k}
}
\keyword{datasets}
