% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{chellinger}
\alias{chellinger}
\title{Calculate the Hellinger distance for each species.}
\usage{
chellinger(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Hellinger Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Hellinger distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Hellinger distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Hellinger distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Hellinger distances about it.
}
\examples{
# Example with the iris dataset

chellinger(iris, ~Species, plot = TRUE, plot_title = "Hellinger Distance Between Groups")

# Example with the mtcars dataset
chellinger(mtcars, ~am, plot = TRUE, plot_title = "Hellinger Distance Between Groups")

}
