% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{generate_report_cchebyshev}
\alias{generate_report_cchebyshev}
\title{Generate a Microsoft Word document about the Chebyshev distance matrix and the p-values matrix with corresponding plots.}
\usage{
generate_report_cchebyshev(
  dataset,
  formula,
  pvalue.method = "chisq",
  num.permutations = 10,
  num.bootstraps = 10
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Chebyshev distance matrix and the p_values matrix.}

\item{pvalue.method}{A p_value method used to calculate the matrix, the default value is "chisq". Other methods are "permutation" and "bootstrap".}

\item{num.permutations}{Number of permutation to specify if you select "permutation" in "pvalue.method". The default value is 100.}

\item{num.bootstraps}{Number of bootstrap to specify if you select "bootstrap" in "p_value method". The default value is 10.}
}
\value{
A Microsoft Word document about the Chebyshev distance matrix and the p_values matrix.
}
\description{
This function takes a dataframe, a factor and returns a Microsoft Word document about the Chebyshev distance matrix and the p-values matrix with corresponding plots.
}
\examples{
# Generate a report about "Species" factor in iris dataset
generate_report_cchebyshev(iris, ~Species)

# Generate a report about "am" factor in mtcars dataset
generate_report_cchebyshev(mtcars, ~am)

}
