% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newton.R
\name{newton}
\alias{newton}
\title{Newton's method}
\usage{
newton(f, fp, x, tol = 0.001, m = 100)
}
\arguments{
\item{f}{function to integrate}

\item{fp}{function representing the derivative of \code{f}}

\item{x}{an initial estimate of the root}

\item{tol}{the error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the real root found
}
\description{
Use Newton's method to find real roots
}
\details{
Newton's method finds real roots of a function, but requires knowing
the function derivative.  It will return when the interval between
them is less than \code{tol}, the error tolerance.  However, this
implementation also stops after \code{m} iterations.
}
\examples{
f <- function(x) { x^3 - 2 * x^2 - 159 * x - 540 }
fp <- function(x) {3 * x^2 - 4 * x - 159 }
newton(f, fp, 1)

}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{goldsect}}, \code{\link{gradient}},
  \code{\link{hillclimbing}}, \code{\link{sa}},
  \code{\link{secant}}
}

