% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic.R
\name{quadratic}
\alias{quadratic}
\alias{quadratic2}
\title{The quadratic equation.}
\usage{
quadratic(b2, b1, b0)

quadratic2(b2, b1, b0)
}
\arguments{
\item{b2}{the coefficient of the x^2 term}

\item{b1}{the coefficient of the x term}

\item{b0}{the constant term}
}
\value{
numeric vector of solutions to the equation
}
\description{
Find the zeros of a quadratic equation.
}
\details{
\code{quadratic} and \code{quadratic2} implement the quadratic
equation from standard algebra in two different ways.  The
\code{quadratic} function is susceptible to cascading numerical error
and the \code{quadratic2} has reduced potential error.
}
\examples{
quadratic(1, 0, -1)
quadratic(4, -4, 1)
quadratic2(1, 0, -1)
quadratic2(4, -4, 1)
}
\seealso{
Other algebra: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{division}},
  \code{\link{fibonacci}}, \code{\link{horner}},
  \code{\link{isPrime}}, \code{\link{linterp}},
  \code{\link{nthroot}}, \code{\link{polyinterp}},
  \code{\link{pwiselinterp}}
}

